/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.okhttp3.internal.cache;

import java.io.IOException;
import org.testcontainers.shaded.kotlin.Metadata;
import org.testcontainers.shaded.kotlin.Unit;
import org.testcontainers.shaded.kotlin.jvm.functions.Function1;
import org.testcontainers.shaded.kotlin.jvm.internal.Intrinsics;
import org.testcontainers.shaded.okio.Buffer;
import org.testcontainers.shaded.okio.ForwardingSink;
import org.testcontainers.shaded.okio.Sink;
import org.testcontainers.shaded.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/testcontainers/shaded/okhttp3/internal/cache/FaultHidingSink;", "Lorg/testcontainers/shaded/okio/ForwardingSink;", "delegate", "Lorg/testcontainers/shaded/okio/Sink;", "onException", "Lorg/testcontainers/shaded/kotlin/Function1;", "Ljava/io/IOException;", "", "<init>", "(Lokio/Sink;Lkotlin/jvm/functions/Function1;)V", "getOnException", "()Lkotlin/jvm/functions/Function1;", "hasErrors", "", "write", "source", "Lorg/testcontainers/shaded/okio/Buffer;", "byteCount", "", "flush", "close", "okhttp"})
public class FaultHidingSink
extends ForwardingSink {
    @NotNull
    private final Function1<IOException, Unit> onException;
    private boolean hasErrors;

    public FaultHidingSink(@NotNull Sink delegate, @NotNull Function1<? super IOException, Unit> onException) {
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        Intrinsics.checkNotNullParameter(onException, "onException");
        super(delegate);
        this.onException = onException;
    }

    @NotNull
    public final Function1<IOException, Unit> getOnException() {
        return this.onException;
    }

    @Override
    public void write(@NotNull Buffer source2, long byteCount) {
        Intrinsics.checkNotNullParameter(source2, "source");
        if (this.hasErrors) {
            source2.skip(byteCount);
            return;
        }
        try {
            super.write(source2, byteCount);
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException.invoke(e);
        }
    }

    @Override
    public void flush() {
        if (this.hasErrors) {
            return;
        }
        try {
            super.flush();
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException.invoke(e);
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException.invoke(e);
        }
    }
}

