/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.solace;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Ulimit;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.shaded.org.apache.commons.lang3.tuple.Pair;
import org.testcontainers.shaded.org.awaitility.Awaitility;
import org.testcontainers.solace.Service;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class SolaceContainer
extends GenericContainer<SolaceContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"solace/solace-pubsub-standard");
    private static final String DEFAULT_VPN = "default";
    private static final String DEFAULT_USERNAME = "default";
    private static final String SOLACE_READY_MESSAGE = ".*Running pre-startup checks:.*";
    private static final String SOLACE_ACTIVE_MESSAGE = "Primary Virtual Router is now active";
    private static final String TMP_SCRIPT_LOCATION = "/tmp/script.cli";
    private static final Long SHM_SIZE = (long)Math.pow(1024.0, 3.0);
    private String username = "root";
    private String password = "password";
    private String vpn = "default";
    private final List<Pair<String, Service>> topicsConfiguration = new ArrayList<Pair<String, Service>>();
    private boolean withClientCert;

    public SolaceContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public SolaceContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withShmSize(SHM_SIZE).withUlimits(new Ulimit[]{new Ulimit("nofile", 2448L, 6592L)}));
        this.waitStrategy = Wait.forLogMessage((String)SOLACE_READY_MESSAGE, (int)1).withStartupTimeout(Duration.ofSeconds(60L));
        this.withExposedPorts(new Integer[]{8080});
        this.withEnv("username_admin_globalaccesslevel", "admin");
        this.withEnv("username_admin_password", "admin");
    }

    protected void configure() {
        this.withCopyToContainer(this.createConfigurationScript(), TMP_SCRIPT_LOCATION);
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        if (this.withClientCert) {
            this.executeCommand("cp", "/tmp/solace.pem", "/usr/sw/jail/certs/solace.pem");
            this.executeCommand("cp", "/tmp/rootCA.crt", "/usr/sw/jail/certs/rootCA.crt");
        }
        this.executeCommand("cp", TMP_SCRIPT_LOCATION, "/usr/sw/jail/cliscripts/script.cli");
        this.waitOnCommandResult(SOLACE_ACTIVE_MESSAGE, "grep", "-R", SOLACE_ACTIVE_MESSAGE, "/usr/sw/jail/logs/system.log");
        this.executeCommand("/usr/sw/loads/currentload/bin/cli", "-A", "-es", "script.cli");
    }

    private Transferable createConfigurationScript() {
        StringBuilder scriptBuilder = new StringBuilder();
        this.updateConfigScript(scriptBuilder, "enable");
        this.updateConfigScript(scriptBuilder, "configure");
        if (!this.vpn.equals("default")) {
            this.updateConfigScript(scriptBuilder, "create message-vpn " + this.vpn);
            this.updateConfigScript(scriptBuilder, "no shutdown");
            this.updateConfigScript(scriptBuilder, "exit");
        }
        if (this.username.equals("default")) {
            throw new RuntimeException("Cannot override password for default client");
        }
        this.updateConfigScript(scriptBuilder, "create client-username " + this.username + " message-vpn " + this.vpn);
        this.updateConfigScript(scriptBuilder, "password " + this.password);
        this.updateConfigScript(scriptBuilder, "no shutdown");
        this.updateConfigScript(scriptBuilder, "exit");
        if (this.withClientCert) {
            this.updateConfigScript(scriptBuilder, "authentication");
            this.updateConfigScript(scriptBuilder, "create client-certificate-authority RootCA");
            this.updateConfigScript(scriptBuilder, "certificate file rootCA.crt");
            this.updateConfigScript(scriptBuilder, "show client-certificate-authority ca-name *");
            this.updateConfigScript(scriptBuilder, "end");
            this.updateConfigScript(scriptBuilder, "configure");
            this.updateConfigScript(scriptBuilder, "ssl");
            this.updateConfigScript(scriptBuilder, "server-certificate solace.pem");
            this.updateConfigScript(scriptBuilder, "cipher-suite msg-backbone name AES128-SHA");
            this.updateConfigScript(scriptBuilder, "exit");
            this.updateConfigScript(scriptBuilder, "message-vpn " + this.vpn);
            this.updateConfigScript(scriptBuilder, "authentication client-certificate");
            this.updateConfigScript(scriptBuilder, "allow-api-provided-username");
            this.updateConfigScript(scriptBuilder, "no shutdown");
            this.updateConfigScript(scriptBuilder, "end");
        } else {
            this.updateConfigScript(scriptBuilder, "message-vpn " + this.vpn);
            this.updateConfigScript(scriptBuilder, "authentication basic auth-type internal");
            this.updateConfigScript(scriptBuilder, "no shutdown");
            this.updateConfigScript(scriptBuilder, "end");
        }
        if (!this.topicsConfiguration.isEmpty()) {
            this.updateConfigScript(scriptBuilder, "configure");
            this.updateConfigScript(scriptBuilder, "acl-profile default message-vpn " + this.vpn);
            this.updateConfigScript(scriptBuilder, "subscribe-topic default-action disallow");
            this.updateConfigScript(scriptBuilder, "publish-topic default-action disallow");
            this.updateConfigScript(scriptBuilder, "exit");
            this.updateConfigScript(scriptBuilder, "message-vpn " + this.vpn);
            this.updateConfigScript(scriptBuilder, "service");
            for (Pair<String, Service> topicConfig : this.topicsConfiguration) {
                Service service = (Service)((Object)topicConfig.getValue());
                String topicName = (String)topicConfig.getKey();
                this.updateConfigScript(scriptBuilder, service.getName());
                if (service.isSupportSSL()) {
                    if (this.withClientCert) {
                        this.updateConfigScript(scriptBuilder, "ssl");
                    } else {
                        this.updateConfigScript(scriptBuilder, "plain-text");
                    }
                }
                this.updateConfigScript(scriptBuilder, "no shutdown");
                this.updateConfigScript(scriptBuilder, "end");
                this.updateConfigScript(scriptBuilder, "configure");
                this.updateConfigScript(scriptBuilder, "acl-profile default message-vpn " + this.vpn);
                this.updateConfigScript(scriptBuilder, String.format("publish-topic exceptions %s list %s", service.getName(), topicName));
                this.updateConfigScript(scriptBuilder, String.format("subscribe-topic exceptions %s list %s", service.getName(), topicName));
                this.updateConfigScript(scriptBuilder, "end");
            }
        }
        return Transferable.of((String)scriptBuilder.toString());
    }

    private void executeCommand(String ... command) {
        try {
            Container.ExecResult execResult = this.execInContainer(command);
            if (execResult.getExitCode() != 0) {
                this.logCommandError(execResult.getStderr(), command);
            }
        }
        catch (IOException | InterruptedException e) {
            this.logCommandError(e.getMessage(), command);
        }
    }

    private void updateConfigScript(StringBuilder scriptBuilder, String command) {
        scriptBuilder.append(command).append("\n");
    }

    private void waitOnCommandResult(String waitingFor, String ... command) {
        Awaitility.await().pollInterval(Duration.ofMillis(500L)).timeout(Duration.ofSeconds(30L)).until(() -> {
            try {
                return this.execInContainer(command).getStdout().contains(waitingFor);
            }
            catch (IOException | InterruptedException e) {
                this.logCommandError(e.getMessage(), command);
                return true;
            }
        });
    }

    private void logCommandError(String error, String ... command) {
        this.logger().error("Could not execute command {}: {}", (Object)command, (Object)error);
    }

    public SolaceContainer withCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public SolaceContainer withTopic(String topic, Service service) {
        this.topicsConfiguration.add((Pair<String, Service>)Pair.of((Object)topic, (Object)((Object)service)));
        this.addExposedPort(service.getPort());
        return this;
    }

    public SolaceContainer withVpn(String vpn) {
        this.vpn = vpn;
        return this;
    }

    public SolaceContainer withClientCert(MountableFile certFile, MountableFile caFile) {
        this.withClientCert = true;
        return (SolaceContainer)((SolaceContainer)this.withCopyFileToContainer(certFile, "/tmp/solace.pem")).withCopyFileToContainer(caFile, "/tmp/rootCA.crt");
    }

    public String getVpn() {
        return this.vpn;
    }

    public String getOrigin(Service service) {
        return String.format("%s://%s:%s", service.getProtocol(), this.getHost(), this.getMappedPort(service.getPort()));
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

