/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.freemarker.core;

import java.util.Date;
import org.testcontainers.shaded.freemarker.core.BuiltIn;
import org.testcontainers.shaded.freemarker.core.Environment;
import org.testcontainers.shaded.freemarker.core.EvalUtil;
import org.testcontainers.shaded.freemarker.core.Expression;
import org.testcontainers.shaded.freemarker.core.InvalidReferenceException;
import org.testcontainers.shaded.freemarker.core.NonDateException;
import org.testcontainers.shaded.freemarker.template.TemplateDateModel;
import org.testcontainers.shaded.freemarker.template.TemplateException;
import org.testcontainers.shaded.freemarker.template.TemplateModel;

abstract class BuiltInForDate
extends BuiltIn {
    BuiltInForDate() {
    }

    @Override
    TemplateModel _eval(Environment env) throws TemplateException {
        TemplateModel model = this.target.eval(env);
        if (model instanceof TemplateDateModel) {
            TemplateDateModel tdm = (TemplateDateModel)model;
            return this.calculateResult(EvalUtil.modelToDate(tdm, this.target), tdm.getDateType(), env);
        }
        throw BuiltInForDate.newNonDateException(env, model, this.target);
    }

    protected abstract TemplateModel calculateResult(Date var1, int var2, Environment var3) throws TemplateException;

    static TemplateException newNonDateException(Environment env, TemplateModel model, Expression target) throws InvalidReferenceException {
        TemplateException e = model == null ? InvalidReferenceException.getInstance(target, env) : new NonDateException(target, model, "date", env);
        return e;
    }
}

