/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.util.ArrayList;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class PulsarContainer
extends GenericContainer<PulsarContainer> {
    public static final int BROKER_PORT = 6650;
    public static final int BROKER_HTTP_PORT = 8080;
    @Deprecated
    public static final String METRICS_ENDPOINT = "/metrics";
    private static final String ADMIN_CLUSTERS_ENDPOINT = "/admin/v2/clusters";
    private static final String TRANSACTION_TOPIC_ENDPOINT = "/admin/v2/persistent/pulsar/system/transaction_coordinator_assign/partitions";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"apachepulsar/pulsar");
    @Deprecated
    private static final String DEFAULT_TAG = "2.10.0";
    private boolean functionsWorkerEnabled = false;
    private boolean transactionsEnabled = false;

    @Deprecated
    public PulsarContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    @Deprecated
    public PulsarContainer(String pulsarVersion) {
        this(DEFAULT_IMAGE_NAME.withTag(pulsarVersion));
    }

    public PulsarContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DockerImageName.parse((String)"apachepulsar/pulsar")});
        this.withExposedPorts(new Integer[]{6650, 8080});
    }

    protected void configure() {
        super.configure();
        this.setupCommandAndEnv();
    }

    public PulsarContainer withFunctionsWorker() {
        this.functionsWorkerEnabled = true;
        return this;
    }

    public PulsarContainer withTransactions() {
        this.transactionsEnabled = true;
        return this;
    }

    public String getPulsarBrokerUrl() {
        return String.format("pulsar://%s:%s", this.getHost(), this.getMappedPort(6650));
    }

    public String getHttpServiceUrl() {
        return String.format("http://%s:%s", this.getHost(), this.getMappedPort(8080));
    }

    protected void setupCommandAndEnv() {
        String standaloneBaseCommand = "/pulsar/bin/apply-config-from-env.py /pulsar/conf/standalone.conf && bin/pulsar standalone";
        if (!this.functionsWorkerEnabled) {
            standaloneBaseCommand = standaloneBaseCommand + " --no-functions-worker -nss";
        }
        this.withCommand(new String[]{"/bin/bash", "-c", standaloneBaseCommand});
        ArrayList<Object> waitStrategies = new ArrayList<Object>();
        waitStrategies.add(Wait.defaultWaitStrategy());
        waitStrategies.add(Wait.forHttp((String)ADMIN_CLUSTERS_ENDPOINT).forPort(8080).forResponsePredicate("[\"standalone\"]"::equals));
        if (this.transactionsEnabled) {
            this.withEnv("PULSAR_PREFIX_transactionCoordinatorEnabled", "true");
            waitStrategies.add(Wait.forHttp((String)TRANSACTION_TOPIC_ENDPOINT).forStatusCode(200).forPort(8080));
        }
        if (this.functionsWorkerEnabled) {
            waitStrategies.add(Wait.forLogMessage((String)".*Function worker service started.*", (int)1));
        }
        WaitAllStrategy compoundedWaitStrategy = new WaitAllStrategy();
        waitStrategies.forEach(arg_0 -> ((WaitAllStrategy)compoundedWaitStrategy).withStrategy(arg_0));
        this.waitingFor((WaitStrategy)compoundedWaitStrategy);
    }
}

