/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class PulsarContainer
extends GenericContainer<PulsarContainer> {
    public static final int BROKER_PORT = 6650;
    public static final int BROKER_HTTP_PORT = 8080;
    public static final String METRICS_ENDPOINT = "/metrics";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"apachepulsar/pulsar");
    @Deprecated
    private static final String DEFAULT_TAG = "2.2.0";
    private boolean functionsWorkerEnabled = false;

    @Deprecated
    public PulsarContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    @Deprecated
    public PulsarContainer(String pulsarVersion) {
        this(DEFAULT_IMAGE_NAME.withTag(pulsarVersion));
    }

    public PulsarContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DockerImageName.parse((String)"apachepulsar/pulsar")});
        this.withExposedPorts(new Integer[]{6650, 8080});
        this.withCommand(new String[]{"/pulsar/bin/pulsar", "standalone", "--no-functions-worker", "-nss"});
        this.waitingFor((WaitStrategy)Wait.forHttp((String)METRICS_ENDPOINT).forStatusCode(200).forPort(8080));
    }

    protected void configure() {
        super.configure();
        if (this.functionsWorkerEnabled) {
            this.withCommand(new String[]{"/pulsar/bin/pulsar", "standalone"});
            this.waitingFor((WaitStrategy)new WaitAllStrategy().withStrategy(this.waitStrategy).withStrategy((WaitStrategy)Wait.forLogMessage((String)".*Function worker service started.*", (int)1)));
        }
    }

    public PulsarContainer withFunctionsWorker() {
        this.functionsWorkerEnabled = true;
        return this;
    }

    public String getPulsarBrokerUrl() {
        return String.format("pulsar://%s:%s", this.getHost(), this.getMappedPort(6650));
    }

    public String getHttpServiceUrl() {
        return String.format("http://%s:%s", this.getHost(), this.getMappedPort(8080));
    }
}

