/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.utility.LicenseAcceptance;

public class MSSQLServerContainer<SELF extends MSSQLServerContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    public static final String NAME = "sqlserver";
    public static final String IMAGE = "mcr.microsoft.com/mssql/server";
    public static final String DEFAULT_TAG = "2017-CU12";
    public static final Integer MS_SQL_SERVER_PORT = 1433;
    static final String DEFAULT_USER = "SA";
    static final String DEFAULT_PASSWORD = "A_Str0ng_Required_Password";
    private String password = "A_Str0ng_Required_Password";
    private static final int DEFAULT_STARTUP_TIMEOUT_SECONDS = 240;
    private static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 240;
    private static final Pattern[] PASSWORD_CATEGORY_VALIDATION_PATTERNS = new Pattern[]{Pattern.compile("[A-Z]+"), Pattern.compile("[a-z]+"), Pattern.compile("[0-9]+"), Pattern.compile("[^a-zA-Z0-9]+", 2)};

    public MSSQLServerContainer() {
        this("mcr.microsoft.com/mssql/server:2017-CU12");
    }

    public MSSQLServerContainer(String dockerImageName) {
        super(dockerImageName);
        this.withStartupTimeoutSeconds(240);
        this.withConnectTimeoutSeconds(240);
        this.addExposedPort(MS_SQL_SERVER_PORT);
    }

    protected Integer getLivenessCheckPort() {
        return this.getMappedPort(MS_SQL_SERVER_PORT);
    }

    protected void configure() {
        LicenseAcceptance.assertLicenseAccepted((String)this.getDockerImageName());
        this.addEnv("ACCEPT_EULA", "Y");
        this.addEnv("SA_PASSWORD", this.password);
    }

    public String getDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    public String getJdbcUrl() {
        return "jdbc:sqlserver://" + this.getContainerIpAddress() + ":" + this.getMappedPort(MS_SQL_SERVER_PORT);
    }

    public String getUsername() {
        return DEFAULT_USER;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }

    public SELF withPassword(String password) {
        this.checkPasswordStrength(password);
        this.password = password;
        return (SELF)((Object)((MSSQLServerContainer)this.self()));
    }

    private void checkPasswordStrength(String password) {
        if (password == null) {
            throw new IllegalArgumentException("Null password is not allowed");
        }
        if (password.length() < 8) {
            throw new IllegalArgumentException("Password should be at least 8 characters long");
        }
        if (password.length() > 128) {
            throw new IllegalArgumentException("Password can be up to 128 characters long");
        }
        long satisfiedCategories = Stream.of(PASSWORD_CATEGORY_VALIDATION_PATTERNS).filter(p -> p.matcher(password).find()).count();
        if (satisfiedCategories < 3L) {
            throw new IllegalArgumentException("Password must contain characters from three of the following four categories:\n - Latin uppercase letters (A through Z)\n - Latin lowercase letters (a through z)\n - Base 10 digits (0 through 9)\n - Non-alphanumeric characters such as: exclamation point (!), dollar sign ($), number sign (#), or percent (%).");
        }
    }
}

