/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.mongodb;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class MongoDBAtlasLocalContainer
extends GenericContainer<MongoDBAtlasLocalContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"mongodb/mongodb-atlas-local");
    private static final int MONGODB_INTERNAL_PORT = 27017;
    private static final String MONGODB_DATABASE_NAME_DEFAULT = "test";
    private static final String DIRECT_CONNECTION = "directConnection=true";

    public MongoDBAtlasLocalContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public MongoDBAtlasLocalContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{27017});
        this.waitingFor((WaitStrategy)Wait.forSuccessfulCommand((String)"runner healthcheck"));
    }

    public String getConnectionString() {
        return this.baseConnectionString() + "/?" + DIRECT_CONNECTION;
    }

    private String baseConnectionString() {
        return String.format("mongodb://%s:%d", this.getHost(), this.getMappedPort(27017));
    }

    public String getDatabaseConnectionString() {
        return this.getDatabaseConnectionString(MONGODB_DATABASE_NAME_DEFAULT);
    }

    public String getDatabaseConnectionString(String databaseName) {
        if (!this.isRunning()) {
            throw new IllegalStateException("MongoDBContainer should be started first");
        }
        return this.baseConnectionString() + "/" + databaseName + "?" + DIRECT_CONNECTION;
    }
}

