/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.Set;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.r2dbc.R2DBCDatabaseContainer;

public class MariaDBR2DBCDatabaseContainer
implements R2DBCDatabaseContainer {
    private final MariaDBContainer<?> container;

    public static ConnectionFactoryOptions getOptions(MariaDBContainer<?> container) {
        ConnectionFactoryOptions options = ConnectionFactoryOptions.builder().option(ConnectionFactoryOptions.DRIVER, (Object)"mariadb").build();
        return new MariaDBR2DBCDatabaseContainer(container).configure(options);
    }

    public ConnectionFactoryOptions configure(ConnectionFactoryOptions options) {
        return options.mutate().option(ConnectionFactoryOptions.HOST, (Object)this.container.getContainerIpAddress()).option(ConnectionFactoryOptions.PORT, (Object)this.container.getMappedPort(MariaDBContainer.MARIADB_PORT)).option(ConnectionFactoryOptions.DATABASE, (Object)this.container.getDatabaseName()).option(ConnectionFactoryOptions.USER, (Object)this.container.getUsername()).option(ConnectionFactoryOptions.PASSWORD, (Object)this.container.getPassword()).build();
    }

    public MariaDBR2DBCDatabaseContainer(MariaDBContainer<?> container) {
        this.container = container;
    }

    public Set<Startable> getDependencies() {
        return this.container.getDependencies();
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    public void close() {
        this.container.close();
    }
}

