/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.util.Objects;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.JdbcDatabaseContainerProvider;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.jdbc.ConnectionUrl;

public class MariaDBContainerProvider
extends JdbcDatabaseContainerProvider {
    private static final String USER_PARAM = "user";
    private static final String PASSWORD_PARAM = "password";

    public boolean supports(String databaseType) {
        return databaseType.equals("mariadb");
    }

    public JdbcDatabaseContainer newInstance() {
        return this.newInstance("10.3.6");
    }

    public JdbcDatabaseContainer newInstance(String tag) {
        return new MariaDBContainer("mariadb:" + tag);
    }

    public JdbcDatabaseContainer newInstance(ConnectionUrl connectionUrl) {
        Objects.requireNonNull(connectionUrl, "Connection URL cannot be null");
        String databaseName = connectionUrl.getDatabaseName().orElse("test");
        String user = connectionUrl.getQueryParameters().getOrDefault(USER_PARAM, "test");
        String password = connectionUrl.getQueryParameters().getOrDefault(PASSWORD_PARAM, "test");
        JdbcDatabaseContainer instance = connectionUrl.getImageTag().isPresent() ? this.newInstance((String)connectionUrl.getImageTag().get()) : this.newInstance();
        return instance.withDatabaseName(databaseName).withUsername(user).withPassword(password);
    }
}

