/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class SpannerEmulatorContainer
extends GenericContainer<SpannerEmulatorContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"gcr.io/cloud-spanner-emulator/emulator");
    private static final int GRPC_PORT = 9010;
    private static final int HTTP_PORT = 9020;

    public SpannerEmulatorContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public SpannerEmulatorContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{9010, 9020});
        this.setWaitStrategy((WaitStrategy)new LogMessageWaitStrategy().withRegEx(".*Cloud Spanner emulator running\\..*"));
    }

    public String getEmulatorGrpcEndpoint() {
        return this.getHost() + ":" + this.getMappedPort(9010);
    }

    public String getEmulatorHttpEndpoint() {
        return this.getHost() + ":" + this.getMappedPort(9020);
    }
}

