/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.couchbase;

public class BucketDefinition {
    private final String name;
    private boolean queryPrimaryIndex = true;
    private int quota = 100;

    public BucketDefinition(String name) {
        this.name = name;
    }

    public BucketDefinition withQuota(int quota) {
        if (quota < 100) {
            throw new IllegalArgumentException("Bucket quota cannot be less than 100MB!");
        }
        this.quota = quota;
        return this;
    }

    public BucketDefinition withPrimaryIndex(boolean create) {
        this.queryPrimaryIndex = create;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasPrimaryIndex() {
        return this.queryPrimaryIndex;
    }

    public int getQuota() {
        return this.quota;
    }
}

