/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.couchbase;

import com.couchbase.client.core.utils.Base64;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.cluster.AuthDomain;
import com.couchbase.client.java.cluster.BucketSettings;
import com.couchbase.client.java.cluster.ClusterManager;
import com.couchbase.client.java.cluster.UserRole;
import com.couchbase.client.java.cluster.UserSettings;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.query.Index;
import com.couchbase.client.java.query.Statement;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.utils.Sets;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.SocatContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.couchbase.CouchbaseQueryServiceWaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.google.common.collect.Lists;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.ThrowingFunction;

public class CouchbaseContainer
extends GenericContainer<CouchbaseContainer> {
    public static final String VERSION = "5.5.1";
    public static final String DOCKER_IMAGE_NAME = "couchbase/server:";
    public static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String STATIC_CONFIG = "/opt/couchbase/etc/couchbase/static_config";
    public static final String CAPI_CONFIG = "/opt/couchbase/etc/couchdb/default.d/capi.ini";
    private static final int REQUIRED_DEFAULT_PASSWORD_LENGTH = 6;
    private String memoryQuota = "300";
    private String indexMemoryQuota = "300";
    private String clusterUsername = "Administrator";
    private String clusterPassword = "password";
    private boolean keyValue = true;
    private boolean query = true;
    private boolean index = true;
    private boolean primaryIndex = true;
    private boolean fts = false;
    private final AtomicReference<Object> couchbaseEnvironment = new AtomicReference();
    private final AtomicReference<Object> couchbaseCluster = new AtomicReference();
    private List<BucketAndUserSettings> newBuckets = new ArrayList<BucketAndUserSettings>();
    private String urlBase;
    private SocatContainer proxy;

    public CouchbaseContainer() {
        this("couchbase/server:5.5.1");
    }

    public CouchbaseContainer(String containerName) {
        super(containerName);
        this.withNetwork(Network.SHARED);
        this.withNetworkAliases(new String[]{"couchbase-" + Base58.randomString((int)6)});
        this.setWaitStrategy((WaitStrategy)new HttpWaitStrategy().forPath("/ui/index.html"));
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return Sets.newHashSet((Object[])new Integer[]{this.getMappedPort(CouchbasePort.REST)});
    }

    protected void configure() {
        if (this.clusterPassword.length() < 6) {
            this.logger().warn("The provided cluster admin password length is less then the default password policy length. Cluster start will fail if configured password requirements are not met.");
        }
    }

    protected void doStart() {
        String networkAlias = (String)this.getNetworkAliases().get(0);
        this.startProxy(networkAlias);
        for (CouchbasePort port : CouchbasePort.values()) {
            this.exposePortThroughProxy(networkAlias, port.getOriginalPort(), this.getMappedPort(port));
        }
        super.doStart();
    }

    private void startProxy(String networkAlias) {
        this.proxy = (SocatContainer)new SocatContainer().withNetwork(this.getNetwork());
        for (CouchbasePort port : CouchbasePort.values()) {
            if (port.isDynamic()) {
                this.proxy.withTarget(port.getOriginalPort(), networkAlias);
                continue;
            }
            this.proxy.addExposedPort(Integer.valueOf(port.getOriginalPort()));
        }
        this.proxy.setWaitStrategy(null);
        this.proxy.start();
    }

    private void exposePortThroughProxy(String networkAlias, int originalPort, int mappedPort) {
        ExecCreateCmdResponse createCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(this.proxy.getContainerId()).withCmd(new String[]{"/usr/bin/socat", "TCP-LISTEN:" + originalPort + ",fork,reuseaddr", "TCP:" + networkAlias + ":" + mappedPort}).exec();
        this.dockerClient.execStartCmd(createCmdResponse.getId()).exec((ResultCallback)new ExecStartResultCallback());
    }

    public List<Integer> getExposedPorts() {
        return this.proxy.getExposedPorts();
    }

    public String getContainerIpAddress() {
        return this.proxy.getContainerIpAddress();
    }

    public Integer getMappedPort(int originalPort) {
        return this.proxy.getMappedPort(originalPort);
    }

    protected Integer getMappedPort(CouchbasePort port) {
        return this.getMappedPort(port.getOriginalPort());
    }

    public List<Integer> getBoundPortNumbers() {
        return this.proxy.getBoundPortNumbers();
    }

    public void stop() {
        this.stopCluster();
        Runnable[] runnableArray = new Runnable[2];
        runnableArray[0] = () -> super.stop();
        runnableArray[1] = () -> ((SocatContainer)this.proxy).stop();
        ((Stream)Stream.of(runnableArray).parallel()).forEach(Runnable::run);
    }

    private void stopCluster() {
        this.getCouchbaseCluster().disconnect();
        this.getCouchbaseEnvironment().shutdown();
    }

    public CouchbaseContainer withNewBucket(BucketSettings bucketSettings) {
        this.newBuckets.add(new BucketAndUserSettings(bucketSettings));
        return (CouchbaseContainer)this.self();
    }

    public CouchbaseContainer withNewBucket(BucketSettings bucketSettings, UserSettings userSettings) {
        this.newBuckets.add(new BucketAndUserSettings(bucketSettings, userSettings));
        return (CouchbaseContainer)this.self();
    }

    public void initCluster() {
        this.urlBase = String.format("http://%s:%s", this.getContainerIpAddress(), this.getMappedPort(CouchbasePort.REST));
        String poolURL = "/pools/default";
        String poolPayload = "memoryQuota=" + URLEncoder.encode(this.memoryQuota, "UTF-8") + "&indexMemoryQuota=" + URLEncoder.encode(this.indexMemoryQuota, "UTF-8");
        String setupServicesURL = "/node/controller/setupServices";
        StringBuilder servicePayloadBuilder = new StringBuilder();
        if (this.keyValue) {
            servicePayloadBuilder.append("kv,");
        }
        if (this.query) {
            servicePayloadBuilder.append("n1ql,");
        }
        if (this.index) {
            servicePayloadBuilder.append("index,");
        }
        if (this.fts) {
            servicePayloadBuilder.append("fts,");
        }
        String setupServiceContent = "services=" + URLEncoder.encode(servicePayloadBuilder.toString(), "UTF-8");
        String webSettingsURL = "/settings/web";
        String webSettingsContent = "username=" + URLEncoder.encode(this.clusterUsername, "UTF-8") + "&password=" + URLEncoder.encode(this.clusterPassword, "UTF-8") + "&port=8091";
        this.callCouchbaseRestAPI(poolURL, poolPayload);
        this.callCouchbaseRestAPI(setupServicesURL, setupServiceContent);
        this.callCouchbaseRestAPI(webSettingsURL, webSettingsContent);
        this.createNodeWaitStrategy().waitUntilReady((WaitStrategyTarget)this);
        this.callCouchbaseRestAPI("/settings/indexes", "indexerThreads=0&logLevel=info&maxRollbackPoints=5&storageMode=memory_optimized");
    }

    @NotNull
    private HttpWaitStrategy createNodeWaitStrategy() {
        return new HttpWaitStrategy().forPath("/pools/default/").withBasicCredentials(this.clusterUsername, this.clusterPassword).forStatusCode(200).forResponsePredicate(response -> {
            try {
                return Optional.of(MAPPER.readTree(response)).map(n -> n.at("/nodes/0/status")).map(JsonNode::asText).map("healthy"::equals).orElse(false);
            }
            catch (IOException e) {
                this.logger().error("Unable to parse response {}", response);
                return false;
            }
        });
    }

    public void createBucket(BucketSettings bucketSetting, UserSettings userSettings, boolean primaryIndex) {
        ClusterManager clusterManager = this.getCouchbaseCluster().clusterManager(this.clusterUsername, this.clusterPassword);
        BucketSettings bucketSettings = clusterManager.insertBucket(bucketSetting);
        try {
            clusterManager.upsertUser(AuthDomain.LOCAL, bucketSetting.name(), userSettings);
        }
        catch (Exception e) {
            this.logger().warn("Unable to insert user '" + bucketSetting.name() + "', maybe you are using older version");
        }
        if (this.index) {
            Bucket bucket = this.getCouchbaseCluster().openBucket(bucketSettings.name(), bucketSettings.password());
            new CouchbaseQueryServiceWaitStrategy(bucket).waitUntilReady((WaitStrategyTarget)this);
            if (primaryIndex) {
                bucket.query((Statement)Index.createPrimaryIndex().on(bucketSetting.name()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callCouchbaseRestAPI(String url, String payload) throws IOException {
        String fullUrl = this.urlBase + url;
        HttpURLConnection httpConnection = (HttpURLConnection)new URL(fullUrl).openConnection();
        try {
            httpConnection.setDoOutput(true);
            httpConnection.setRequestMethod("POST");
            httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String encoded = Base64.encode((byte[])(this.clusterUsername + ":" + this.clusterPassword).getBytes("UTF-8"));
            httpConnection.setRequestProperty("Authorization", "Basic " + encoded);
            DataOutputStream out = new DataOutputStream(httpConnection.getOutputStream());
            try {
                out.writeBytes(payload);
                out.flush();
                httpConnection.getResponseCode();
            }
            finally {
                if (Collections.singletonList(out).get(0) != null) {
                    out.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(httpConnection).get(0) != null) {
                httpConnection.disconnect();
            }
        }
    }

    protected void containerIsCreated(String containerId) {
        this.patchConfig(STATIC_CONFIG, (ThrowingFunction<String, String>)((ThrowingFunction)this::addMappedPorts));
        this.patchConfig(CAPI_CONFIG, (ThrowingFunction<String, String>)((ThrowingFunction)this::replaceCapiPort));
    }

    private void patchConfig(String configLocation, ThrowingFunction<String, String> patchFunction) {
        String patchedConfig = (String)this.copyFileFromContainer(configLocation, inputStream -> (String)patchFunction.apply((Object)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8)));
        this.copyFileToContainer(Transferable.of((byte[])patchedConfig.getBytes(StandardCharsets.UTF_8)), configLocation);
    }

    private String addMappedPorts(String originalConfig) {
        String portConfig = Stream.of(CouchbasePort.values()).filter(port -> !port.isDynamic()).map(port -> String.format("{%s, %d}.", port.name, this.getMappedPort((CouchbasePort)((Object)port)))).collect(Collectors.joining("\n"));
        return String.format("%s\n%s", originalConfig, portConfig);
    }

    private String replaceCapiPort(String originalConfig) {
        return Arrays.stream(originalConfig.split("\n")).map(s -> s.matches("port\\s*=\\s*" + CouchbasePort.CAPI.getOriginalPort()) ? "port = " + this.getMappedPort(CouchbasePort.CAPI) : s).collect(Collectors.joining("\n"));
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        if (!this.newBuckets.isEmpty()) {
            for (BucketAndUserSettings bucket : this.newBuckets) {
                this.createBucket(bucket.getBucketSettings(), bucket.getUserSettings(), this.primaryIndex);
            }
        }
    }

    private CouchbaseCluster createCouchbaseCluster() {
        return CouchbaseCluster.create((CouchbaseEnvironment)this.getCouchbaseEnvironment(), (String[])new String[]{this.getContainerIpAddress()});
    }

    private DefaultCouchbaseEnvironment createCouchbaseEnvironment() {
        this.initCluster();
        return ((DefaultCouchbaseEnvironment.Builder)((DefaultCouchbaseEnvironment.Builder)((DefaultCouchbaseEnvironment.Builder)((DefaultCouchbaseEnvironment.Builder)DefaultCouchbaseEnvironment.builder().kvTimeout(10000L).bootstrapCarrierDirectPort(this.getMappedPort(CouchbasePort.MEMCACHED).intValue())).bootstrapCarrierSslPort(this.getMappedPort(CouchbasePort.MEMCACHED_SSL).intValue())).bootstrapHttpDirectPort(this.getMappedPort(CouchbasePort.REST).intValue())).bootstrapHttpSslPort(this.getMappedPort(CouchbasePort.REST_SSL).intValue())).build();
    }

    public CouchbaseContainer withMemoryQuota(String memoryQuota) {
        this.memoryQuota = memoryQuota;
        return (CouchbaseContainer)this.self();
    }

    public CouchbaseContainer withIndexMemoryQuota(String indexMemoryQuota) {
        this.indexMemoryQuota = indexMemoryQuota;
        return (CouchbaseContainer)this.self();
    }

    public CouchbaseContainer withClusterAdmin(String username, String password) {
        this.clusterUsername = username;
        this.clusterPassword = password;
        return (CouchbaseContainer)this.self();
    }

    public CouchbaseContainer withKeyValue(boolean keyValue) {
        this.keyValue = keyValue;
        return (CouchbaseContainer)this.self();
    }

    public CouchbaseContainer withQuery(boolean query) {
        this.query = query;
        return (CouchbaseContainer)this.self();
    }

    public CouchbaseContainer withIndex(boolean index) {
        this.index = index;
        return (CouchbaseContainer)this.self();
    }

    public CouchbaseContainer withPrimaryIndex(boolean primaryIndex) {
        this.primaryIndex = primaryIndex;
        return (CouchbaseContainer)this.self();
    }

    public CouchbaseContainer withFts(boolean fts) {
        this.fts = fts;
        return (CouchbaseContainer)this.self();
    }

    public CouchbaseContainer(String memoryQuota, String indexMemoryQuota, String clusterUsername, String clusterPassword, boolean keyValue, boolean query, boolean index, boolean primaryIndex, boolean fts, List<BucketAndUserSettings> newBuckets, String urlBase, SocatContainer proxy) {
        this.memoryQuota = memoryQuota;
        this.indexMemoryQuota = indexMemoryQuota;
        this.clusterUsername = clusterUsername;
        this.clusterPassword = clusterPassword;
        this.keyValue = keyValue;
        this.query = query;
        this.index = index;
        this.primaryIndex = primaryIndex;
        this.fts = fts;
        this.newBuckets = newBuckets;
        this.urlBase = urlBase;
        this.proxy = proxy;
    }

    public boolean isQuery() {
        return this.query;
    }

    public boolean isIndex() {
        return this.index;
    }

    public boolean isPrimaryIndex() {
        return this.primaryIndex;
    }

    public boolean isFts() {
        return this.fts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CouchbaseEnvironment getCouchbaseEnvironment() {
        Object value = this.couchbaseEnvironment.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.couchbaseEnvironment;
            synchronized (atomicReference) {
                value = this.couchbaseEnvironment.get();
                if (value == null) {
                    DefaultCouchbaseEnvironment actualValue = this.createCouchbaseEnvironment();
                    value = actualValue == null ? this.couchbaseEnvironment : actualValue;
                    this.couchbaseEnvironment.set(value);
                }
            }
        }
        return (CouchbaseEnvironment)(value == this.couchbaseEnvironment ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CouchbaseCluster getCouchbaseCluster() {
        Object value = this.couchbaseCluster.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.couchbaseCluster;
            synchronized (atomicReference) {
                value = this.couchbaseCluster.get();
                if (value == null) {
                    CouchbaseCluster actualValue = this.createCouchbaseCluster();
                    value = actualValue == null ? this.couchbaseCluster : actualValue;
                    this.couchbaseCluster.set(value);
                }
            }
        }
        return (CouchbaseCluster)(value == this.couchbaseCluster ? null : value);
    }

    private final class BucketAndUserSettings {
        private final BucketSettings bucketSettings;
        private final UserSettings userSettings;

        public BucketAndUserSettings(BucketSettings bucketSettings) {
            this.bucketSettings = bucketSettings;
            this.userSettings = UserSettings.build().password(bucketSettings.password()).roles(this.getDefaultAdminRoles(bucketSettings.name()));
        }

        private List<UserRole> getDefaultAdminRoles(String bucketName) {
            return Lists.newArrayList((Object[])new UserRole[]{new UserRole("bucket_admin", bucketName), new UserRole("views_admin", bucketName), new UserRole("query_manage_index", bucketName), new UserRole("query_update", bucketName), new UserRole("query_select", bucketName), new UserRole("query_insert", bucketName), new UserRole("query_delete", bucketName)});
        }

        public BucketSettings getBucketSettings() {
            return this.bucketSettings;
        }

        public UserSettings getUserSettings() {
            return this.userSettings;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BucketAndUserSettings)) {
                return false;
            }
            BucketAndUserSettings other = (BucketAndUserSettings)o;
            BucketSettings this$bucketSettings = this.getBucketSettings();
            BucketSettings other$bucketSettings = other.getBucketSettings();
            if (this$bucketSettings == null ? other$bucketSettings != null : !this$bucketSettings.equals(other$bucketSettings)) {
                return false;
            }
            UserSettings this$userSettings = this.getUserSettings();
            UserSettings other$userSettings = other.getUserSettings();
            return !(this$userSettings == null ? other$userSettings != null : !this$userSettings.equals(other$userSettings));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BucketSettings $bucketSettings = this.getBucketSettings();
            result = result * 59 + ($bucketSettings == null ? 43 : $bucketSettings.hashCode());
            UserSettings $userSettings = this.getUserSettings();
            result = result * 59 + ($userSettings == null ? 43 : $userSettings.hashCode());
            return result;
        }

        public String toString() {
            return "CouchbaseContainer.BucketAndUserSettings(bucketSettings=" + this.getBucketSettings() + ", userSettings=" + this.getUserSettings() + ")";
        }

        public BucketAndUserSettings(BucketSettings bucketSettings, UserSettings userSettings) {
            this.bucketSettings = bucketSettings;
            this.userSettings = userSettings;
        }
    }

    protected static enum CouchbasePort {
        REST("rest_port", 8091, true),
        CAPI("capi_port", 8092, false),
        QUERY("query_port", 8093, false),
        FTS("fts_http_port", 8094, false),
        CBAS("cbas_http_port", 8095, false),
        EVENTING("eventing_http_port", 8096, false),
        MEMCACHED_SSL("memcached_ssl_port", 11207, false),
        MEMCACHED("memcached_port", 11210, false),
        REST_SSL("ssl_rest_port", 18091, true),
        CAPI_SSL("ssl_capi_port", 18092, false),
        QUERY_SSL("ssl_query_port", 18093, false),
        FTS_SSL("fts_ssl_port", 18094, false),
        CBAS_SSL("cbas_ssl_port", 18095, false),
        EVENTING_SSL("eventing_ssl_port", 18096, false);

        final String name;
        final int originalPort;
        final boolean dynamic;

        public String getName() {
            return this.name;
        }

        public int getOriginalPort() {
            return this.originalPort;
        }

        public boolean isDynamic() {
            return this.dynamic;
        }

        private CouchbasePort(String name, int originalPort, boolean dynamic) {
            this.name = name;
            this.originalPort = originalPort;
            this.dynamic = dynamic;
        }
    }
}

