/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.clickhouse;

import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.ConnectionFactoryOptions;
import javax.annotation.Nullable;
import org.testcontainers.clickhouse.ClickHouseContainer;
import org.testcontainers.clickhouse.ClickHouseR2DBCDatabaseContainer;
import org.testcontainers.r2dbc.R2DBCDatabaseContainer;
import org.testcontainers.r2dbc.R2DBCDatabaseContainerProvider;

public class ClickHouseR2DBCDatabaseContainerProvider
implements R2DBCDatabaseContainerProvider {
    static final String DRIVER = "clickhouse";

    public boolean supports(ConnectionFactoryOptions options) {
        return DRIVER.equals(options.getRequiredValue(ConnectionFactoryOptions.DRIVER));
    }

    public R2DBCDatabaseContainer createContainer(ConnectionFactoryOptions options) {
        String image = "clickhouse/clickhouse-server:" + options.getRequiredValue(IMAGE_TAG_OPTION);
        ClickHouseContainer container = new ClickHouseContainer(image).withDatabaseName((String)options.getRequiredValue(ConnectionFactoryOptions.DATABASE));
        if (Boolean.TRUE.equals(options.getValue(REUSABLE_OPTION))) {
            container.withReuse(true);
        }
        return new ClickHouseR2DBCDatabaseContainer(container);
    }

    @Nullable
    public ConnectionFactoryMetadata getMetadata(ConnectionFactoryOptions options) {
        ConnectionFactoryOptions.Builder builder = options.mutate();
        if (!options.hasOption(ConnectionFactoryOptions.USER)) {
            builder.option(ConnectionFactoryOptions.USER, (Object)"default");
        }
        if (!options.hasOption(ConnectionFactoryOptions.PASSWORD)) {
            builder.option(ConnectionFactoryOptions.PASSWORD, (Object)"");
        }
        builder.option(ConnectionFactoryOptions.PROTOCOL, (Object)"http");
        return super.getMetadata(builder.build());
    }
}

