/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.updatesreceivers;

import org.telegram.telegrambots.meta.generics.BackOff;

public class ExponentialBackOff
implements BackOff {
    private static final int DEFAULT_INITIAL_INTERVAL_MILLIS = 500;
    private static final double DEFAULT_RANDOMIZATION_FACTOR = 0.5;
    private static final double DEFAULT_MULTIPLIER = 1.5;
    private static final int DEFAULT_MAX_INTERVAL_MILLIS = 900000;
    private static final int DEFAULT_MAX_ELAPSED_TIME_MILLIS = 3600000;
    private int currentIntervalMillis;
    private final int initialIntervalMillis;
    private final double randomizationFactor;
    private final double multiplier;
    private final int maxIntervalMillis;
    private long startTimeNanos;
    private final int maxElapsedTimeMillis;

    ExponentialBackOff() {
        this(new Builder());
    }

    private ExponentialBackOff(Builder builder) {
        this.initialIntervalMillis = builder.initialIntervalMillis;
        this.randomizationFactor = builder.randomizationFactor;
        this.multiplier = builder.multiplier;
        this.maxIntervalMillis = builder.maxIntervalMillis;
        this.maxElapsedTimeMillis = builder.maxElapsedTimeMillis;
        if (this.initialIntervalMillis <= 0) {
            throw new IllegalArgumentException("InitialIntervalMillis must not be negative");
        }
        if (this.maxElapsedTimeMillis <= 0) {
            throw new IllegalArgumentException("MaxElapsedTimeMillis must not be negative");
        }
        if (this.multiplier < 1.0) {
            throw new IllegalArgumentException("Multiplier must be bigger than 0");
        }
        if (this.maxIntervalMillis < this.initialIntervalMillis) {
            throw new IllegalArgumentException("InitialIntervalMillis must be smaller or equal maxIntervalMillis");
        }
        if (this.randomizationFactor < 0.0 || this.randomizationFactor >= 1.0) {
            throw new IllegalArgumentException("RandomizationFactor must be between 0 and 1");
        }
        this.reset();
    }

    public void reset() {
        this.currentIntervalMillis = this.initialIntervalMillis;
        this.startTimeNanos = this.nanoTime();
    }

    public long nextBackOffMillis() {
        if (this.getElapsedTimeMillis() > (long)this.maxElapsedTimeMillis) {
            return this.maxElapsedTimeMillis;
        }
        int randomizedInterval = ExponentialBackOff.getRandomValueFromInterval(this.randomizationFactor, Math.random(), this.currentIntervalMillis);
        this.incrementCurrentInterval();
        return randomizedInterval;
    }

    private static int getRandomValueFromInterval(double randomizationFactor, double random, int currentIntervalMillis) {
        double delta = randomizationFactor * (double)currentIntervalMillis;
        double minInterval = (double)currentIntervalMillis - delta;
        double maxInterval = (double)currentIntervalMillis + delta;
        return (int)(minInterval + random * (maxInterval - minInterval + 1.0));
    }

    private long getElapsedTimeMillis() {
        return (this.nanoTime() - this.startTimeNanos) / 1000000L;
    }

    private void incrementCurrentInterval() {
        this.currentIntervalMillis = (double)this.currentIntervalMillis >= (double)this.maxIntervalMillis / this.multiplier ? this.maxIntervalMillis : (int)((double)this.currentIntervalMillis * this.multiplier);
    }

    private long nanoTime() {
        return System.nanoTime();
    }

    public static class Builder {
        int initialIntervalMillis = 500;
        double randomizationFactor = 0.5;
        double multiplier = 1.5;
        int maxIntervalMillis = 900000;
        int maxElapsedTimeMillis = 3600000;

        public Builder setInitialIntervalMillis(int initialIntervalMillis) {
            this.initialIntervalMillis = initialIntervalMillis;
            return this;
        }

        public Builder setRandomizationFactor(double randomizationFactor) {
            this.randomizationFactor = randomizationFactor;
            return this;
        }

        public Builder setMultiplier(double multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        public Builder setMaxIntervalMillis(int maxIntervalMillis) {
            this.maxIntervalMillis = maxIntervalMillis;
            return this;
        }

        public Builder setMaxElapsedTimeMillis(int maxElapsedTimeMillis) {
            this.maxElapsedTimeMillis = maxElapsedTimeMillis;
            return this;
        }

        public ExponentialBackOff build() {
            return new ExponentialBackOff(this);
        }
    }
}

