/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.replykeyboard;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InlineKeyboardMarkup
implements ReplyKeyboard {
    private static final String KEYBOARD_FIELD = "inline_keyboard";
    @JsonProperty(value="inline_keyboard")
    @NonNull
    private List<List<InlineKeyboardButton>> keyboard;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.keyboard == null) {
            throw new TelegramApiValidationException("Keyboard parameter can't be null", this);
        }
        for (List<InlineKeyboardButton> inlineKeyboardButtons : this.keyboard) {
            for (InlineKeyboardButton inlineKeyboardButton : inlineKeyboardButtons) {
                inlineKeyboardButton.validate();
            }
        }
    }

    public static InlineKeyboardMarkupBuilder builder() {
        return new InlineKeyboardMarkupBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineKeyboardMarkup)) {
            return false;
        }
        InlineKeyboardMarkup other = (InlineKeyboardMarkup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<List<InlineKeyboardButton>> this$keyboard = this.getKeyboard();
        List<List<InlineKeyboardButton>> other$keyboard = other.getKeyboard();
        return !(this$keyboard == null ? other$keyboard != null : !((Object)this$keyboard).equals(other$keyboard));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineKeyboardMarkup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<List<InlineKeyboardButton>> $keyboard = this.getKeyboard();
        result = result * 59 + ($keyboard == null ? 43 : ((Object)$keyboard).hashCode());
        return result;
    }

    @NonNull
    public List<List<InlineKeyboardButton>> getKeyboard() {
        return this.keyboard;
    }

    @JsonProperty(value="inline_keyboard")
    public void setKeyboard(@NonNull List<List<InlineKeyboardButton>> keyboard) {
        if (keyboard == null) {
            throw new NullPointerException("keyboard is marked non-null but is null");
        }
        this.keyboard = keyboard;
    }

    public String toString() {
        return "InlineKeyboardMarkup(keyboard=" + this.getKeyboard() + ")";
    }

    public InlineKeyboardMarkup() {
    }

    public InlineKeyboardMarkup(@NonNull List<List<InlineKeyboardButton>> keyboard) {
        if (keyboard == null) {
            throw new NullPointerException("keyboard is marked non-null but is null");
        }
        this.keyboard = keyboard;
    }

    public static class InlineKeyboardMarkupBuilder {
        private ArrayList<List<InlineKeyboardButton>> keyboard;

        InlineKeyboardMarkupBuilder() {
        }

        public InlineKeyboardMarkupBuilder keyboardRow(List<InlineKeyboardButton> keyboardRow) {
            if (this.keyboard == null) {
                this.keyboard = new ArrayList();
            }
            this.keyboard.add(keyboardRow);
            return this;
        }

        @JsonProperty(value="inline_keyboard")
        public InlineKeyboardMarkupBuilder keyboard(Collection<? extends List<InlineKeyboardButton>> keyboard) {
            if (keyboard == null) {
                throw new NullPointerException("keyboard cannot be null");
            }
            if (this.keyboard == null) {
                this.keyboard = new ArrayList();
            }
            this.keyboard.addAll(keyboard);
            return this;
        }

        public InlineKeyboardMarkupBuilder clearKeyboard() {
            if (this.keyboard != null) {
                this.keyboard.clear();
            }
            return this;
        }

        public InlineKeyboardMarkup build() {
            List<List<InlineKeyboardButton>> keyboard;
            switch (this.keyboard == null ? 0 : this.keyboard.size()) {
                case 0: {
                    keyboard = Collections.emptyList();
                    break;
                }
                case 1: {
                    keyboard = Collections.singletonList(this.keyboard.get(0));
                    break;
                }
                default: {
                    keyboard = Collections.unmodifiableList(new ArrayList<List<InlineKeyboardButton>>(this.keyboard));
                }
            }
            return new InlineKeyboardMarkup(keyboard);
        }

        public String toString() {
            return "InlineKeyboardMarkup.InlineKeyboardMarkupBuilder(keyboard=" + this.keyboard + ")";
        }
    }
}

