/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.media;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InputMediaPhoto
extends InputMedia {
    private static final String TYPE = "photo";
    public static final String HASSPOILER_FIELD = "has_spoiler";
    @JsonProperty(value="has_spoiler")
    private Boolean hasSpoiler;

    public InputMediaPhoto() {
    }

    public InputMediaPhoto(@NonNull String media) {
        super(media);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
    }

    public InputMediaPhoto(@NonNull String media, String caption, String parseMode, List<MessageEntity> entities, boolean isNewMedia, String mediaName, File newMediaFile, InputStream newMediaStream, Boolean hasSpoiler) {
        super(media, caption, parseMode, entities, isNewMedia, mediaName, newMediaFile, newMediaStream);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.hasSpoiler = hasSpoiler;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        super.validate();
    }

    public static InputMediaPhotoBuilder builder() {
        return new InputMediaPhotoBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputMediaPhoto)) {
            return false;
        }
        InputMediaPhoto other = (InputMediaPhoto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$hasSpoiler = this.getHasSpoiler();
        Boolean other$hasSpoiler = other.getHasSpoiler();
        return !(this$hasSpoiler == null ? other$hasSpoiler != null : !((Object)this$hasSpoiler).equals(other$hasSpoiler));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InputMediaPhoto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $hasSpoiler = this.getHasSpoiler();
        result = result * 59 + ($hasSpoiler == null ? 43 : ((Object)$hasSpoiler).hashCode());
        return result;
    }

    public Boolean getHasSpoiler() {
        return this.hasSpoiler;
    }

    @JsonProperty(value="has_spoiler")
    public void setHasSpoiler(Boolean hasSpoiler) {
        this.hasSpoiler = hasSpoiler;
    }

    @Override
    public String toString() {
        return "InputMediaPhoto(hasSpoiler=" + this.getHasSpoiler() + ")";
    }

    public static class InputMediaPhotoBuilder {
        private String media;
        private String caption;
        private String parseMode;
        private List<MessageEntity> entities;
        private boolean isNewMedia;
        private String mediaName;
        private File newMediaFile;
        private InputStream newMediaStream;
        private Boolean hasSpoiler;

        InputMediaPhotoBuilder() {
        }

        public InputMediaPhotoBuilder media(@NonNull String media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return this;
        }

        public InputMediaPhotoBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InputMediaPhotoBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public InputMediaPhotoBuilder entities(List<MessageEntity> entities) {
            this.entities = entities;
            return this;
        }

        public InputMediaPhotoBuilder isNewMedia(boolean isNewMedia) {
            this.isNewMedia = isNewMedia;
            return this;
        }

        public InputMediaPhotoBuilder mediaName(String mediaName) {
            this.mediaName = mediaName;
            return this;
        }

        public InputMediaPhotoBuilder newMediaFile(File newMediaFile) {
            this.newMediaFile = newMediaFile;
            return this;
        }

        public InputMediaPhotoBuilder newMediaStream(InputStream newMediaStream) {
            this.newMediaStream = newMediaStream;
            return this;
        }

        public InputMediaPhotoBuilder hasSpoiler(Boolean hasSpoiler) {
            this.hasSpoiler = hasSpoiler;
            return this;
        }

        public InputMediaPhoto build() {
            return new InputMediaPhoto(this.media, this.caption, this.parseMode, this.entities, this.isNewMedia, this.mediaName, this.newMediaFile, this.newMediaStream, this.hasSpoiler);
        }

        public String toString() {
            return "InputMediaPhoto.InputMediaPhotoBuilder(media=" + this.media + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", entities=" + this.entities + ", isNewMedia=" + this.isNewMedia + ", mediaName=" + this.mediaName + ", newMediaFile=" + this.newMediaFile + ", newMediaStream=" + this.newMediaStream + ", hasSpoiler=" + this.hasSpoiler + ")";
        }
    }
}

