/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.media;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.InputStream;
import org.telegram.telegrambots.api.interfaces.InputBotApiObject;
import org.telegram.telegrambots.api.interfaces.Validable;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public abstract class InputMedia<T>
implements InputBotApiObject,
Validable {
    protected static final String TYPE_FIELD = "type";
    private static final String MEDIA_FIELD = "media";
    private static final String CAPTION_FIELD = "caption";
    private static final String PARSEMODE_FIELD = "parse_mode";
    @JsonProperty(value="media")
    private String media;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonIgnore
    private boolean isNewMedia;
    @JsonIgnore
    private String mediaName;
    @JsonIgnore
    private File newMediaFile;
    @JsonIgnore
    private InputStream newMediaStream;

    public InputMedia() {
    }

    public InputMedia(String media, String caption) {
        this.media = media;
        this.caption = caption;
    }

    public String getMedia() {
        return this.media;
    }

    public File getMediaFile() {
        return this.newMediaFile;
    }

    public InputStream getNewMediaStream() {
        return this.newMediaStream;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    @JsonIgnore
    public boolean isNewMedia() {
        return this.isNewMedia;
    }

    public T setMedia(String media) {
        this.media = media;
        this.isNewMedia = false;
        return (T)this;
    }

    public T setMedia(File mediaFile, String fileName) {
        this.newMediaFile = mediaFile;
        this.isNewMedia = true;
        this.mediaName = fileName;
        this.media = "attach://" + fileName;
        return (T)this;
    }

    public T setMedia(InputStream mediaStream, String fileName) {
        this.newMediaStream = mediaStream;
        this.isNewMedia = true;
        this.mediaName = fileName;
        this.media = "attach://" + fileName;
        return (T)this;
    }

    public String getCaption() {
        return this.caption;
    }

    public InputMedia setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InputMedia<T> setParseMode(String parseMode) {
        this.parseMode = parseMode;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.isNewMedia) {
            if (this.mediaName == null || this.mediaName.isEmpty()) {
                throw new TelegramApiValidationException("Media name can't be empty", this);
            }
            if (this.newMediaFile == null && this.newMediaStream == null) {
                throw new TelegramApiValidationException("Media can't be empty", this);
            }
        } else if (this.media == null || this.media.isEmpty()) {
            throw new TelegramApiValidationException("Media can't be empty", this);
        }
    }

    @JsonProperty(value="type")
    public abstract String getType();
}

