/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.toggle;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.telegram.abilitybots.api.objects.Ability;
import org.telegram.abilitybots.api.toggle.AbilityToggle;

public class CustomToggle
implements AbilityToggle {
    public static final String OFF = "turn_off_base_ability";
    private final Map<String, String> baseMapping = new HashMap<String, String>();

    @Override
    public boolean isOff(Ability ability) {
        return OFF.equalsIgnoreCase(this.baseMapping.get(ability.name()));
    }

    @Override
    public Ability processAbility(Ability ability) {
        if (this.baseMapping.containsKey(ability.name())) {
            return Ability.builder().basedOn(ability).name(this.baseMapping.get(ability.name())).build();
        }
        return ability;
    }

    public CustomToggle toggle(String abilityName, String targetName) {
        this.baseMapping.put(abilityName, targetName);
        return this;
    }

    public CustomToggle turnOff(String ability) {
        this.baseMapping.put(ability, OFF);
        return this;
    }

    public CustomToggle config(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            key = key.toLowerCase();
            for (Property p : Property.values()) {
                if (!key.equals(p.key())) continue;
                String ability = key.split("\\.")[1];
                if (key.contains("enabled") && value.equalsIgnoreCase("false")) {
                    this.turnOff(ability);
                    continue;
                }
                if (!key.contains("toggle")) continue;
                this.toggle(ability, value);
            }
        }
        return this;
    }

    public static enum Property {
        CLAIM_ENABLED("ability.claim.enabled"),
        CLAIM_TOGGLE("ability.claim.toggle"),
        BAN_ENABLED("ability.ban.enabled"),
        BAN_TOGGLE("ability.ban.toggle"),
        PROMOTE_ENABLED("ability.promote.enabled"),
        PROMOTE_TOGGLE("ability.promote.toggle"),
        DEMOTE_ENABLED("ability.demote.enabled"),
        DEMOTE_TOGGLE("ability.demote.toggle"),
        UNBAN_ENABLED("ability.unban.enabled"),
        UNBAN_TOGGLE("ability.unban.toggle"),
        BACKUP_ENABLED("ability.backup.enabled"),
        BACKUP_TOGGLE("ability.backup.toggle"),
        RECOVER_ENABLED("ability.recover.enabled"),
        RECOVER_TOGGLE("ability.recover.toggle"),
        COMMANDS_ENABLED("ability.commands.enabled"),
        COMMANDS_TOGGLE("ability.commands.toggle"),
        REPORT_ENABLED("ability.report.enabled"),
        REPORT_TOGGLE("ability.report.toggle"),
        STATS_ENABLED("ability.stats.enabled"),
        STATS_TOGGLE("ability.stats.toggle");

        private final String key;

        private Property(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }
}

