/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.shared.help.FormHelpPanel;
import org.jboss.as.console.client.shared.subsys.Baseadress;
import org.jboss.as.console.client.teiid.TransportEditor;
import org.jboss.as.console.client.teiid.model.Transport;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormAdapter;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.FormValidation;
import org.jboss.ballroom.client.widgets.window.DialogueOptions;
import org.jboss.ballroom.client.widgets.window.TrappedFocusPanel;
import org.jboss.ballroom.client.widgets.window.WindowContentBuilder;
import org.jboss.dmr.client.ModelNode;

public class TransportWizard {
    private DeckPanel deck;
    private TrappedFocusPanel trap;
    private TransportEditor editor;

    public TransportWizard(TransportEditor editor) {
        this.editor = editor;
    }

    public Widget asWidget() {
        this.deck = new DeckPanel(){

            public void showWidget(int index) {
                super.showWidget(index);
                TransportWizard.this.trap.getFocus().reset((Element)this.getWidget(index).getElement());
                TransportWizard.this.trap.getFocus().onFirstInput();
            }
        };
        List<FormItem<?>> commonItems = TransportEditor.buildCommonFormItems();
        this.deck.add(this.stepWizard(commonItems.toArray(new FormItem[commonItems.size()]), 0, true));
        this.trap = new TrappedFocusPanel((Widget)this.deck);
        this.deck.showWidget(0);
        return this.trap;
    }

    Widget stepWizard(FormItem<?>[] formItems, final int currentStep, boolean finalStep) {
        VerticalPanel layout = new VerticalPanel();
        layout.setStyleName("window-content");
        layout.add((Widget)new HTML("<h3> Add Transport</h3>"));
        final Form form = new Form(Transport.class);
        form.setFields(formItems);
        FormHelpPanel helpPanel = new FormHelpPanel(new FormHelpPanel.AddressCallback(){

            public ModelNode getAddress() {
                ModelNode address = Baseadress.get();
                address.add("subsystem", "teiid");
                address.add("transport", "*");
                return address;
            }
        }, (FormAdapter)form);
        layout.add(helpPanel.asWidget());
        layout.add(form.asWidget());
        ClickHandler nextHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                FormValidation validation = form.validate();
                if (!validation.hasErrors()) {
                    Transport t = (Transport)form.getUpdatedEntity();
                    TransportWizard.this.nextStep(t, currentStep);
                }
            }
        };
        ClickHandler cancelHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                TransportWizard.this.closeDialogue();
            }
        };
        ClickHandler submitHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                FormValidation validation = form.validate();
                if (!validation.hasErrors()) {
                    Transport t = (Transport)form.getUpdatedEntity();
                    TransportWizard.this.finishStep(t);
                }
            }
        };
        DialogueOptions options = null;
        options = finalStep ? new DialogueOptions(Console.CONSTANTS.common_label_finish(), submitHandler, Console.CONSTANTS.common_label_cancel(), cancelHandler) : new DialogueOptions(Console.CONSTANTS.common_label_next(), nextHandler, Console.CONSTANTS.common_label_cancel(), cancelHandler);
        return new WindowContentBuilder((Widget)layout, (Widget)options).build();
    }

    private void nextStep(Transport updated, int currentStep) {
        if (currentStep < 2) {
            this.deck.showWidget(currentStep + 1);
        }
    }

    private void finishStep(Transport updated) {
        this.editor.createNewTransport(updated);
    }

    private void closeDialogue() {
        this.editor.closeNewTransportWizard();
    }
}

