/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.layout.OneToOneLayout;
import org.jboss.as.console.client.teiid.SubsystemPresenter;
import org.jboss.as.console.client.teiid.model.TeiidLogger;
import org.jboss.ballroom.client.widgets.tools.ToolButton;

public class AuditEditor {
    public static final String CTX_COMMANDLOGGING = "org.teiid.COMMAND_LOG";
    public static final String CTX_AUDITLOGGING = "org.teiid.AUDIT_LOG";
    public static final String CTX_TRACELOGGING = "org.teiid";
    private static final String DEBUG = "DEBUG";
    private SubsystemPresenter presenter;
    final CheckBox auditBtn = new CheckBox("Enable Audit Logging");
    final CheckBox commandBtn = new CheckBox("Enable Command Logging");
    final CheckBox traceBtn = new CheckBox("Enable Trace Logging");

    public AuditEditor(SubsystemPresenter presenter) {
        this.presenter = presenter;
    }

    public Widget asWidget() {
        HTML title = new HTML();
        title.setStyleName("content-header-label");
        title.setText("Audit/Command Logging");
        OneToOneLayout layoutBuilder = new OneToOneLayout().setPlain(true).setTitle("Audit/Command Logging").setHeadlineWidget((Widget)title).setDescription("Turn On/Off Audit/Command Logging. By default file handler(s) will be added. Alternatively, add TEIID_COMMAND_LOG/TEIID_AUDIT_LOG handlers to override the default handlers").addDetail("Logging", (Widget)this.createLogPanel());
        return layoutBuilder.build();
    }

    private CaptionPanel createLogPanel() {
        CaptionPanel captionPanel = new CaptionPanel("Select Logging Type");
        ToolButton applyBtn = new ToolButton("Apply", new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                AuditEditor.this.presenter.addOrRemoveLogger(AuditEditor.CTX_AUDITLOGGING, AuditEditor.this.auditBtn.getValue());
                AuditEditor.this.presenter.addOrRemoveLogger(AuditEditor.CTX_COMMANDLOGGING, AuditEditor.this.commandBtn.getValue());
                AuditEditor.this.presenter.addOrRemoveLogger(AuditEditor.CTX_TRACELOGGING, AuditEditor.this.traceBtn.getValue());
            }
        });
        VerticalPanel selectionPanel = new VerticalPanel();
        selectionPanel.add((Widget)this.auditBtn);
        selectionPanel.add((Widget)this.commandBtn);
        selectionPanel.add((Widget)this.traceBtn);
        selectionPanel.add((Widget)applyBtn);
        selectionPanel.setCellHorizontalAlignment((Widget)this.auditBtn, HasHorizontalAlignment.ALIGN_LEFT);
        selectionPanel.setCellHorizontalAlignment((Widget)this.commandBtn, HasHorizontalAlignment.ALIGN_LEFT);
        selectionPanel.setCellHorizontalAlignment((Widget)this.traceBtn, HasHorizontalAlignment.ALIGN_LEFT);
        captionPanel.add((Widget)selectionPanel);
        captionPanel.setWidth("40%");
        captionPanel.getElement().setAttribute("style", "font-weight:bold;");
        return captionPanel;
    }

    public void loggingStatus(String context, TeiidLogger logger) {
        if (CTX_AUDITLOGGING.equals(context)) {
            if (logger != null && logger.getLevel().equals(DEBUG)) {
                this.auditBtn.setValue(Boolean.TRUE);
            } else {
                this.auditBtn.setValue(Boolean.FALSE);
            }
        }
        if (CTX_COMMANDLOGGING.equals(context)) {
            if (logger != null && logger.getLevel().equals(DEBUG)) {
                this.commandBtn.setValue(Boolean.TRUE);
            } else {
                this.commandBtn.setValue(Boolean.FALSE);
            }
        }
        if (CTX_TRACELOGGING.equals(context)) {
            if (logger != null && logger.getLevel().equals("TRACE")) {
                this.traceBtn.setValue(Boolean.TRUE);
            } else {
                this.traceBtn.setValue(Boolean.FALSE);
            }
        }
    }

    public void logHandlerAdded(String handlerName, boolean added) {
        if (!added) {
            Console.info((String)("Addition Logging handler " + handlerName + " failed"));
        }
    }

    public void logHandlerRemoved(String handlerName, boolean removed) {
        if (!removed) {
            Console.info((String)("Removal of Logging handler " + handlerName + " failed"));
        }
    }

    public void loggerAdded(String context, boolean added) {
        if (!added) {
            Console.info((String)("Addition of Logger " + context + " failed"));
        }
    }

    public void loggerRemoved(String context, boolean removed) {
        if (!removed) {
            Console.info((String)("Removal of Logger " + context + " failed"));
        }
    }

    public void addLogger(String context) {
        if (context.equals(CTX_AUDITLOGGING)) {
            this.presenter.checkLogHandlerStatus(context, "TEIID_AUDIT_LOG", true);
        }
        if (context.equals(CTX_COMMANDLOGGING)) {
            this.presenter.checkLogHandlerStatus(context, "TEIID_COMMAND_LOG", true);
        }
        if (context.equals(CTX_TRACELOGGING)) {
            this.presenter.addLogger(context, "TRACE", null);
        }
    }

    public void setLogHandlerStatus(String context, String name, boolean dbAppender, boolean exists) {
        if (exists) {
            if (context.equals(CTX_AUDITLOGGING)) {
                this.presenter.addLogger(context, DEBUG, "TEIID_AUDIT_LOG");
            }
            if (context.equals(CTX_COMMANDLOGGING)) {
                this.presenter.addLogger(context, DEBUG, "TEIID_COMMAND_LOG");
            }
        } else if (dbAppender) {
            if (context.equals(CTX_AUDITLOGGING)) {
                this.presenter.checkLogHandlerStatus(context, "TEIID_AUDIT_LOG", false);
            }
            if (context.equals(CTX_COMMANDLOGGING)) {
                this.presenter.checkLogHandlerStatus(context, "TEIID_COMMAND_LOG", false);
            }
        } else {
            if (context.equals(CTX_AUDITLOGGING)) {
                this.presenter.addFileHandler("TEIID_AUDIT_LOG", "teiid-audit.log");
                this.presenter.addLogger(context, DEBUG, "TEIID_AUDIT_LOG");
            }
            if (context.equals(CTX_COMMANDLOGGING)) {
                this.presenter.addFileHandler("TEIID_COMMAND_LOG", "teiid-command.log");
                this.presenter.addLogger(context, DEBUG, "TEIID_COMMAND_LOG");
            }
        }
    }

    public void deleteLogger(String context) {
        if (context.equals(CTX_AUDITLOGGING)) {
            this.presenter.removeLogger(context);
        }
        if (context.equals(CTX_COMMANDLOGGING)) {
            this.presenter.removeLogger(context);
        }
        if (context.equals(CTX_TRACELOGGING)) {
            this.presenter.removeLogger(context);
        }
    }
}

