/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.components.vault.jcache;

import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.cache.Cache;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import lombok.Generated;

public class CacheSizeManager<K, V>
implements CacheEntryCreatedListener<K, V>,
CacheEntryExpiredListener<K, V>,
CacheEntryRemovedListener<K, V>,
Consumer<Cache<K, V>> {
    private final int maxCacheSize;
    private Cache<K, V> cache;
    private final CopyOnWriteArrayList<K> keys = new CopyOnWriteArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreated(Iterable<CacheEntryEvent<? extends K, ? extends V>> cacheEntryEvents) throws CacheEntryListenerException {
        cacheEntryEvents.forEach(it -> this.keys.add(it.getKey()));
        if (this.keys.size() > this.maxCacheSize) {
            Iterator<K> iterator = this.keys.iterator();
            CacheSizeManager cacheSizeManager = this;
            synchronized (cacheSizeManager) {
                while (this.keys.size() > this.maxCacheSize && iterator.hasNext()) {
                    this.cache.remove(iterator.next());
                    iterator.remove();
                }
            }
        }
    }

    public void onExpired(Iterable<CacheEntryEvent<? extends K, ? extends V>> cacheEntryEvents) throws CacheEntryListenerException {
        this.onRemoved(cacheEntryEvents);
    }

    public void onRemoved(Iterable<CacheEntryEvent<? extends K, ? extends V>> cacheEntryEvents) throws CacheEntryListenerException {
        cacheEntryEvents.forEach(it -> this.keys.remove(it.getKey()));
    }

    @Override
    public void accept(Cache<K, V> cache) {
        this.cache = cache;
    }

    @Generated
    public CacheSizeManager(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }
}

