/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.components.vault.client;

import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.cache.Cache;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.json.bind.annotation.JsonbProperty;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.components.vault.client.DecryptedValue;
import org.talend.sdk.components.vault.client.VaultClientSetup;
import org.talend.sdk.components.vault.client.VaultHttp;
import org.talend.sdk.components.vault.configuration.Documentation;
import org.talend.sdk.components.vault.server.error.ErrorPayload;

@ApplicationScoped
public class VaultClient {
    private static final Logger log = LoggerFactory.getLogger(VaultClient.class);
    @Inject
    private VaultClientSetup setup;
    @Inject
    @VaultHttp
    private WebTarget vault;
    @Inject
    @Documentation(value="The vault path to retrieve a token.")
    @ConfigProperty(name="talend.vault.cache.vault.auth.endpoint", defaultValue="v1/auth/engines/login")
    private String authEndpoint;
    @Inject
    @Documentation(value="The vault path to decrypt values. You can use the variable `{x-talend-tenant-id}` to replace by `x-talend-tenant-id` header value.")
    @ConfigProperty(name="talend.vault.cache.vault.decrypt.endpoint", defaultValue="v1/tenants-keyrings/decrypt/{x-talend-tenant-id}")
    private String decryptEndpoint;
    @Inject
    @Documentation(value="The vault token to use to log in (will make roleId and secretId ignored). `-` means it is ignored.")
    @ConfigProperty(name="talend.vault.cache.vault.auth.token", defaultValue="-")
    private Supplier<String> token;
    @Inject
    @Documentation(value="The vault role identifier to use to log in (if token is not set). `-` means it is ignored.")
    @ConfigProperty(name="talend.vault.cache.vault.auth.roleId", defaultValue="-")
    private Supplier<String> role;
    @Inject
    @Documentation(value="The vault secret identifier to use to log in (if token is not set). `-` means it is ignored.")
    @ConfigProperty(name="talend.vault.cache.vault.auth.secretId", defaultValue="-")
    private Supplier<String> secret;
    @Inject
    @Documentation(value="How often (in ms) to refresh the vault token.")
    @ConfigProperty(name="talend.vault.cache.service.auth.refreshDelayMargin", defaultValue="600000")
    private Long refreshDelayMargin;
    @Inject
    @Documentation(value="How long (in ms) to wait before retrying a recoverable error or refresh the vault token in case of an authentication failure.")
    @ConfigProperty(name="talend.vault.cache.service.auth.refreshDelayOnFailure", defaultValue="1000")
    private Long refreshDelayOnFailure;
    @Inject
    @Documentation(value="How many times do we retry a recoverable operation in case of a failure.")
    @ConfigProperty(name="talend.vault.cache.service.auth.numberOfRetryOnFailure", defaultValue="3")
    private Integer numberOfRetryOnFailure;
    @Inject
    @Documentation(value="Status code sent when vault can't decipher some values.")
    @ConfigProperty(name="talend.vault.cache.service.auth.cantDecipherStatusCode", defaultValue="422")
    private Integer cantDecipherStatusCode;
    @Inject
    @Documentation(value="The regex to whitelist ciphered keys, others will be passthrough in the output without going to vault.")
    @ConfigProperty(name="talend.vault.cache.service.decipher.skip.regex", defaultValue="vault\\:v[0-9]+\\:.*")
    private String passthroughRegex;
    @Inject
    private Cache<String, DecryptedValue> cache;
    @Inject
    private Clock clock;
    private final AtomicReference<Authentication> authToken = new AtomicReference();
    private ScheduledExecutorService scheduledExecutorService;
    private Pattern compiledPassthroughRegex;
    private final Predicate<Throwable> shouldRetry = cause -> {
        if (WebApplicationException.class.isInstance(cause)) {
            WebApplicationException wae = (WebApplicationException)WebApplicationException.class.cast(cause);
            int status = wae.getResponse().getStatus();
            if (Response.Status.NOT_FOUND.getStatusCode() == status || status >= 500) {
                return false;
            }
        }
        return true;
    };

    @PostConstruct
    private void init() {
        this.compiledPassthroughRegex = Pattern.compile(this.passthroughRegex);
    }

    @PreDestroy
    private void destroy() {
        this.scheduledExecutorService.shutdownNow();
        try {
            this.scheduledExecutorService.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void init(@Observes @Initialized(value=ApplicationScoped.class) ServletContext init) {
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
            private final ThreadGroup group = Optional.ofNullable(System.getSecurityManager()).map(SecurityManager::getThreadGroup).orElseGet(() -> Thread.currentThread().getThreadGroup());

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(this.group, r, "talend-vault-service-refresh", 0L);
                if (t.isDaemon()) {
                    t.setDaemon(false);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        });
    }

    public Map<String, String> decrypt(Map<String, String> values) {
        return this.decrypt(values, null);
    }

    public Map<String, String> decrypt(Map<String, String> values, String tenantId) {
        if ("no-vault".equals(this.setup.getVaultUrl())) {
            return values;
        }
        List cipheredKeys = values.entrySet().stream().filter(entry -> this.compiledPassthroughRegex.matcher((CharSequence)entry.getValue()).matches()).map(cyphered -> (String)cyphered.getKey()).collect(Collectors.toList());
        if (cipheredKeys.isEmpty()) {
            return values;
        }
        Supplier attempt = () -> this.prepareRequest(values, cipheredKeys, tenantId);
        return (Map)this.withRetries(attempt, this.shouldRetry).get();
    }

    private CompletableFuture<Map<String, String>> prepareRequest(Map<String, String> values, List<String> cipheredKeys, String tenantId) {
        return this.get(cipheredKeys.stream().map(values::get).collect(Collectors.toList()), this.clock.millis(), tenantId).thenApply(decrypted -> values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Optional.of(cipheredKeys.indexOf(e.getKey())).filter(idx -> idx >= 0).map(decrypted::get).map(DecryptedValue::getValue).orElseGet(() -> (String)values.get(e.getKey())))));
    }

    private CompletableFuture<List<DecryptedValue>> get(Collection<String> values, long currentTime, String tenantId) {
        AtomicInteger index = new AtomicInteger();
        Collection clearValues = values.stream().map(it -> new EntryWithIndex<String>(index.getAndIncrement(), (String)it)).filter(it -> ((EntryWithIndex)it).entry != null && !this.compiledPassthroughRegex.matcher((CharSequence)((EntryWithIndex)it).entry).matches()).collect(Collectors.toList());
        if (clearValues.isEmpty()) {
            return this.doDecipher(values, currentTime, tenantId).toCompletableFuture();
        }
        if (clearValues.size() == values.size()) {
            long now = this.clock.millis();
            return CompletableFuture.completedFuture(values.stream().map(it -> new DecryptedValue((String)it, now)).collect(Collectors.toList()));
        }
        return this.doDecipher(values, currentTime, tenantId).thenApply(deciphered -> {
            long now = this.clock.millis();
            clearValues.forEach(entry -> deciphered.add(((EntryWithIndex)entry).index, new DecryptedValue((String)((EntryWithIndex)entry).entry, now)));
            return deciphered;
        }).toCompletableFuture();
    }

    private CompletionStage<List<DecryptedValue>> doDecipher(Collection<String> values, long currentTime, String tenantId) {
        Map alreadyCached = new HashSet<String>(values).stream().collect(Collectors.toMap(Function.identity(), it -> Optional.ofNullable((DecryptedValue)this.cache.get(it))));
        Collection missing = alreadyCached.entrySet().stream().filter(it -> !((Optional)it.getValue()).isPresent()).map(Map.Entry::getKey).collect(Collectors.toList());
        if (missing.isEmpty()) {
            return CompletableFuture.completedFuture(values.stream().map(alreadyCached::get).map(Optional::get).collect(Collectors.toList()));
        }
        return this.getOrRequestAuth().thenCompose(auth -> Optional.ofNullable(auth.getAuth()).map(Auth::getClientToken).map(clientToken -> {
            WebTarget path = this.vault.path(this.decryptEndpoint);
            if (this.decryptEndpoint.contains("x-talend-tenant-id")) {
                path = path.resolveTemplate("x-talend-tenant-id", (Object)Optional.ofNullable(tenantId).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorPayload.ErrorDictionary.BAD_FORMAT, "No header x-talend-tenant-id")).build())));
            }
            return ((CompletableFuture)path.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Vault-Token", clientToken).rx().post(Entity.entity((Object)new DecryptRequest(missing.stream().map(it -> new DecryptInput((String)it, null, null)).collect(Collectors.toList())), (MediaType)MediaType.APPLICATION_JSON_TYPE), DecryptResponse.class).toCompletableFuture().thenApply(decrypted -> {
                List errors;
                Collection<DecryptResult> results = decrypted.getData().getBatchResults();
                if (results.isEmpty()) {
                    this.throwError(this.cantDecipherStatusCode, "Decrypted values are empty");
                }
                if (!(errors = results.stream().map(DecryptResult::getError).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
                    this.throwError(this.cantDecipherStatusCode, "Can't decipher properties: " + errors);
                }
                Iterator keyIterator = missing.iterator();
                Map<String, DecryptedValue> decryptedResults = results.stream().map(it -> new String(Base64.getDecoder().decode(it.getPlaintext()), StandardCharsets.UTF_8)).collect(Collectors.toMap(it -> (String)keyIterator.next(), it -> new DecryptedValue((String)it, currentTime)));
                this.cache.putAll(decryptedResults);
                return values.stream().map(it -> decryptedResults.getOrDefault(it, ((Optional)alreadyCached.get(it)).orElse(null))).collect(Collectors.toList());
            })).exceptionally(e -> {
                WebApplicationException wae;
                Response response;
                Throwable cause = e.getCause();
                String message = "";
                int status = this.cantDecipherStatusCode;
                if (WebApplicationException.class.isInstance(cause) && (response = (wae = (WebApplicationException)WebApplicationException.class.cast(cause)).getResponse()) != null) {
                    if (ErrorPayload.class.isInstance(response.getEntity())) {
                        throw wae;
                    }
                    try {
                        message = (String)response.readEntity(String.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    status = response.getStatus();
                    if (status == Response.Status.NOT_FOUND.getStatusCode() && message.isEmpty()) {
                        message = "Decryption failed: Endpoint not found, check your setup.";
                    }
                }
                if (message.isEmpty()) {
                    message = String.format("Decryption failed: %s", cause.getMessage());
                }
                log.error("{} ({}).", (Object)message, (Object)status);
                throw new WebApplicationException(message, Response.status((int)status).entity((Object)new ErrorPayload(ErrorPayload.ErrorDictionary.UNEXPECTED, message)).build());
            });
        }).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorPayload(ErrorPayload.ErrorDictionary.UNEXPECTED, "getOrRequestAuth failed")).build())));
    }

    private CompletionStage<Authentication> getOrRequestAuth() {
        return Optional.of(this.token.get()).filter(this::isReloadableConfigSet).map(value -> {
            Auth authInfo = new Auth();
            authInfo.setClientToken((String)value);
            authInfo.setLeaseDuration(Long.MAX_VALUE);
            authInfo.setRenewable(false);
            return CompletableFuture.completedFuture(new Authentication(authInfo, Long.MAX_VALUE));
        }).orElseGet(() -> {
            String role = Optional.of(this.role.get()).filter(this::isReloadableConfigSet).orElse(null);
            String secret = Optional.of(this.secret.get()).filter(this::isReloadableConfigSet).orElse(null);
            return Optional.ofNullable(this.authToken.get()).filter(auth -> auth.getExpiresAt() - this.clock.millis() <= this.refreshDelayMargin).map(CompletableFuture::completedFuture).orElseGet(() -> this.doAuth(role, secret).toCompletableFuture());
        });
    }

    private CompletionStage<Authentication> doAuth(String role, String secret) {
        log.info("Authenticating to vault");
        return this.vault.path(this.authEndpoint).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).rx().post(Entity.entity((Object)new AuthRequest(role, secret), (MediaType)MediaType.APPLICATION_JSON_TYPE), AuthResponse.class).thenApply(token -> {
            log.debug("Authenticated to vault");
            if (token.getAuth() == null || token.getAuth().getClientToken() == null) {
                this.throwError(500, "Vault didn't return a token");
            } else {
                log.info("Authenticated to vault");
            }
            long validityMargin = TimeUnit.SECONDS.toMillis(token.getAuth().getLeaseDuration());
            long nextRefresh = this.clock.millis() + validityMargin - this.refreshDelayMargin;
            Authentication authentication = new Authentication(token.getAuth(), nextRefresh);
            this.authToken.set(authentication);
            if (!this.scheduledExecutorService.isShutdown() && token.getAuth().isRenewable()) {
                this.scheduledExecutorService.schedule(() -> this.doAuth(role, secret), nextRefresh, TimeUnit.MILLISECONDS);
            }
            return authentication;
        }).exceptionally(e -> {
            Throwable cause = e.getCause();
            if (WebApplicationException.class.isInstance(cause)) {
                WebApplicationException wae = (WebApplicationException)WebApplicationException.class.cast(cause);
                Response response = wae.getResponse();
                String message = "";
                if (ErrorPayload.class.isInstance(wae.getResponse().getEntity())) {
                    throw wae;
                }
                try {
                    message = (String)response.readEntity(String.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (message.isEmpty()) {
                    message = cause.getMessage();
                }
                this.throwError(response.getStatus(), message);
            }
            this.throwError(cause);
            return null;
        });
    }

    private <T> CompletableFuture<T> withRetries(Supplier<CompletableFuture<T>> attempt, Predicate<Throwable> shouldRetry) {
        Executor scheduler = r -> this.scheduledExecutorService.schedule(r, (long)this.refreshDelayOnFailure, TimeUnit.MILLISECONDS);
        CompletableFuture<T> firstAttempt = attempt.get();
        return this.flatten((CompletableFuture<CompletableFuture<T>>)((CompletableFuture)firstAttempt.thenApply(CompletableFuture::completedFuture)).exceptionally(throwable -> this.retryFuture(attempt, 1, (Throwable)throwable, shouldRetry, scheduler)));
    }

    private <T> CompletableFuture<T> retryFuture(Supplier<CompletableFuture<T>> attempter, int attemptsSoFar, Throwable throwable, Predicate<Throwable> shouldRetry, Executor scheduler) {
        int nextAttempt = attemptsSoFar + 1;
        log.info("[retryFuture] Retry failed operation ({}/{}). Reason: {}.", new Object[]{attemptsSoFar, this.numberOfRetryOnFailure, throwable.getMessage()});
        if (nextAttempt > this.numberOfRetryOnFailure || !shouldRetry.test(throwable.getCause())) {
            log.info("[retryFuture] Stop retry failed operation (condition triggered).");
            this.throwError(throwable.getCause());
        }
        return this.flatten((CompletableFuture<CompletableFuture<T>>)((CompletableFuture)this.flatten(CompletableFuture.supplyAsync(attempter, scheduler)).thenApply(CompletableFuture::completedFuture)).exceptionally(nextThrowable -> this.retryFuture(attempter, nextAttempt, (Throwable)nextThrowable, shouldRetry, scheduler)));
    }

    private <T> CompletableFuture<T> flatten(CompletableFuture<CompletableFuture<T>> completableCompletable) {
        return completableCompletable.thenCompose(Function.identity());
    }

    private void throwError(int status, String message) {
        throw new WebApplicationException(message, Response.status((int)status).entity((Object)new ErrorPayload(ErrorPayload.ErrorDictionary.UNEXPECTED, message)).build());
    }

    private void throwError(Throwable cause) {
        String message = "";
        int status = this.cantDecipherStatusCode;
        if (WebApplicationException.class.isInstance(cause)) {
            WebApplicationException wae = (WebApplicationException)WebApplicationException.class.cast(cause);
            Response response = wae.getResponse();
            status = response.getStatus();
            if (response != null) {
                if (ErrorPayload.class.isInstance(response.getEntity())) {
                    throw wae;
                }
                try {
                    message = (String)response.readEntity(String.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (message.isEmpty()) {
            message = cause.getMessage();
        }
        throw new WebApplicationException(message, Response.status((int)status).entity((Object)new ErrorPayload(ErrorPayload.ErrorDictionary.UNEXPECTED, message)).build());
    }

    private boolean isReloadableConfigSet(String value) {
        return !"-".equals(value);
    }

    public VaultClientSetup getSetup() {
        return this.setup;
    }

    public WebTarget getVault() {
        return this.vault;
    }

    public String getAuthEndpoint() {
        return this.authEndpoint;
    }

    public String getDecryptEndpoint() {
        return this.decryptEndpoint;
    }

    public Supplier<String> getToken() {
        return this.token;
    }

    public Supplier<String> getRole() {
        return this.role;
    }

    public Supplier<String> getSecret() {
        return this.secret;
    }

    public Long getRefreshDelayMargin() {
        return this.refreshDelayMargin;
    }

    public Long getRefreshDelayOnFailure() {
        return this.refreshDelayOnFailure;
    }

    public Integer getNumberOfRetryOnFailure() {
        return this.numberOfRetryOnFailure;
    }

    public Integer getCantDecipherStatusCode() {
        return this.cantDecipherStatusCode;
    }

    public String getPassthroughRegex() {
        return this.passthroughRegex;
    }

    public Cache<String, DecryptedValue> getCache() {
        return this.cache;
    }

    public Clock getClock() {
        return this.clock;
    }

    public AtomicReference<Authentication> getAuthToken() {
        return this.authToken;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public Pattern getCompiledPassthroughRegex() {
        return this.compiledPassthroughRegex;
    }

    public Predicate<Throwable> getShouldRetry() {
        return this.shouldRetry;
    }

    public void setSetup(VaultClientSetup setup) {
        this.setup = setup;
    }

    public void setVault(WebTarget vault) {
        this.vault = vault;
    }

    public void setAuthEndpoint(String authEndpoint) {
        this.authEndpoint = authEndpoint;
    }

    public void setDecryptEndpoint(String decryptEndpoint) {
        this.decryptEndpoint = decryptEndpoint;
    }

    public void setToken(Supplier<String> token) {
        this.token = token;
    }

    public void setRole(Supplier<String> role) {
        this.role = role;
    }

    public void setSecret(Supplier<String> secret) {
        this.secret = secret;
    }

    public void setRefreshDelayMargin(Long refreshDelayMargin) {
        this.refreshDelayMargin = refreshDelayMargin;
    }

    public void setRefreshDelayOnFailure(Long refreshDelayOnFailure) {
        this.refreshDelayOnFailure = refreshDelayOnFailure;
    }

    public void setNumberOfRetryOnFailure(Integer numberOfRetryOnFailure) {
        this.numberOfRetryOnFailure = numberOfRetryOnFailure;
    }

    public void setCantDecipherStatusCode(Integer cantDecipherStatusCode) {
        this.cantDecipherStatusCode = cantDecipherStatusCode;
    }

    public void setPassthroughRegex(String passthroughRegex) {
        this.passthroughRegex = passthroughRegex;
    }

    public void setCache(Cache<String, DecryptedValue> cache) {
        this.cache = cache;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void setCompiledPassthroughRegex(Pattern compiledPassthroughRegex) {
        this.compiledPassthroughRegex = compiledPassthroughRegex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VaultClient)) {
            return false;
        }
        VaultClient other = (VaultClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$refreshDelayMargin = this.getRefreshDelayMargin();
        Long other$refreshDelayMargin = other.getRefreshDelayMargin();
        if (this$refreshDelayMargin == null ? other$refreshDelayMargin != null : !((Object)this$refreshDelayMargin).equals(other$refreshDelayMargin)) {
            return false;
        }
        Long this$refreshDelayOnFailure = this.getRefreshDelayOnFailure();
        Long other$refreshDelayOnFailure = other.getRefreshDelayOnFailure();
        if (this$refreshDelayOnFailure == null ? other$refreshDelayOnFailure != null : !((Object)this$refreshDelayOnFailure).equals(other$refreshDelayOnFailure)) {
            return false;
        }
        Integer this$numberOfRetryOnFailure = this.getNumberOfRetryOnFailure();
        Integer other$numberOfRetryOnFailure = other.getNumberOfRetryOnFailure();
        if (this$numberOfRetryOnFailure == null ? other$numberOfRetryOnFailure != null : !((Object)this$numberOfRetryOnFailure).equals(other$numberOfRetryOnFailure)) {
            return false;
        }
        Integer this$cantDecipherStatusCode = this.getCantDecipherStatusCode();
        Integer other$cantDecipherStatusCode = other.getCantDecipherStatusCode();
        if (this$cantDecipherStatusCode == null ? other$cantDecipherStatusCode != null : !((Object)this$cantDecipherStatusCode).equals(other$cantDecipherStatusCode)) {
            return false;
        }
        VaultClientSetup this$setup = this.getSetup();
        VaultClientSetup other$setup = other.getSetup();
        if (this$setup == null ? other$setup != null : !((Object)this$setup).equals(other$setup)) {
            return false;
        }
        WebTarget this$vault = this.getVault();
        WebTarget other$vault = other.getVault();
        if (this$vault == null ? other$vault != null : !this$vault.equals(other$vault)) {
            return false;
        }
        String this$authEndpoint = this.getAuthEndpoint();
        String other$authEndpoint = other.getAuthEndpoint();
        if (this$authEndpoint == null ? other$authEndpoint != null : !this$authEndpoint.equals(other$authEndpoint)) {
            return false;
        }
        String this$decryptEndpoint = this.getDecryptEndpoint();
        String other$decryptEndpoint = other.getDecryptEndpoint();
        if (this$decryptEndpoint == null ? other$decryptEndpoint != null : !this$decryptEndpoint.equals(other$decryptEndpoint)) {
            return false;
        }
        Supplier<String> this$token = this.getToken();
        Supplier<String> other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Supplier<String> this$role = this.getRole();
        Supplier<String> other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        Supplier<String> this$secret = this.getSecret();
        Supplier<String> other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$passthroughRegex = this.getPassthroughRegex();
        String other$passthroughRegex = other.getPassthroughRegex();
        if (this$passthroughRegex == null ? other$passthroughRegex != null : !this$passthroughRegex.equals(other$passthroughRegex)) {
            return false;
        }
        Cache<String, DecryptedValue> this$cache = this.getCache();
        Cache<String, DecryptedValue> other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !this$cache.equals(other$cache)) {
            return false;
        }
        Clock this$clock = this.getClock();
        Clock other$clock = other.getClock();
        if (this$clock == null ? other$clock != null : !((Object)this$clock).equals(other$clock)) {
            return false;
        }
        AtomicReference<Authentication> this$authToken = this.getAuthToken();
        AtomicReference<Authentication> other$authToken = other.getAuthToken();
        if (this$authToken == null ? other$authToken != null : !this$authToken.equals(other$authToken)) {
            return false;
        }
        ScheduledExecutorService this$scheduledExecutorService = this.getScheduledExecutorService();
        ScheduledExecutorService other$scheduledExecutorService = other.getScheduledExecutorService();
        if (this$scheduledExecutorService == null ? other$scheduledExecutorService != null : !this$scheduledExecutorService.equals(other$scheduledExecutorService)) {
            return false;
        }
        Pattern this$compiledPassthroughRegex = this.getCompiledPassthroughRegex();
        Pattern other$compiledPassthroughRegex = other.getCompiledPassthroughRegex();
        if (this$compiledPassthroughRegex == null ? other$compiledPassthroughRegex != null : !this$compiledPassthroughRegex.equals(other$compiledPassthroughRegex)) {
            return false;
        }
        Predicate<Throwable> this$shouldRetry = this.getShouldRetry();
        Predicate<Throwable> other$shouldRetry = other.getShouldRetry();
        return !(this$shouldRetry == null ? other$shouldRetry != null : !this$shouldRetry.equals(other$shouldRetry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VaultClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $refreshDelayMargin = this.getRefreshDelayMargin();
        result = result * 59 + ($refreshDelayMargin == null ? 43 : ((Object)$refreshDelayMargin).hashCode());
        Long $refreshDelayOnFailure = this.getRefreshDelayOnFailure();
        result = result * 59 + ($refreshDelayOnFailure == null ? 43 : ((Object)$refreshDelayOnFailure).hashCode());
        Integer $numberOfRetryOnFailure = this.getNumberOfRetryOnFailure();
        result = result * 59 + ($numberOfRetryOnFailure == null ? 43 : ((Object)$numberOfRetryOnFailure).hashCode());
        Integer $cantDecipherStatusCode = this.getCantDecipherStatusCode();
        result = result * 59 + ($cantDecipherStatusCode == null ? 43 : ((Object)$cantDecipherStatusCode).hashCode());
        VaultClientSetup $setup = this.getSetup();
        result = result * 59 + ($setup == null ? 43 : ((Object)$setup).hashCode());
        WebTarget $vault = this.getVault();
        result = result * 59 + ($vault == null ? 43 : $vault.hashCode());
        String $authEndpoint = this.getAuthEndpoint();
        result = result * 59 + ($authEndpoint == null ? 43 : $authEndpoint.hashCode());
        String $decryptEndpoint = this.getDecryptEndpoint();
        result = result * 59 + ($decryptEndpoint == null ? 43 : $decryptEndpoint.hashCode());
        Supplier<String> $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Supplier<String> $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        Supplier<String> $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $passthroughRegex = this.getPassthroughRegex();
        result = result * 59 + ($passthroughRegex == null ? 43 : $passthroughRegex.hashCode());
        Cache<String, DecryptedValue> $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        Clock $clock = this.getClock();
        result = result * 59 + ($clock == null ? 43 : ((Object)$clock).hashCode());
        AtomicReference<Authentication> $authToken = this.getAuthToken();
        result = result * 59 + ($authToken == null ? 43 : $authToken.hashCode());
        ScheduledExecutorService $scheduledExecutorService = this.getScheduledExecutorService();
        result = result * 59 + ($scheduledExecutorService == null ? 43 : $scheduledExecutorService.hashCode());
        Pattern $compiledPassthroughRegex = this.getCompiledPassthroughRegex();
        result = result * 59 + ($compiledPassthroughRegex == null ? 43 : $compiledPassthroughRegex.hashCode());
        Predicate<Throwable> $shouldRetry = this.getShouldRetry();
        result = result * 59 + ($shouldRetry == null ? 43 : $shouldRetry.hashCode());
        return result;
    }

    public String toString() {
        return "VaultClient(setup=" + this.getSetup() + ", vault=" + this.getVault() + ", authEndpoint=" + this.getAuthEndpoint() + ", decryptEndpoint=" + this.getDecryptEndpoint() + ", token=" + this.getToken() + ", role=" + this.getRole() + ", secret=" + this.getSecret() + ", refreshDelayMargin=" + this.getRefreshDelayMargin() + ", refreshDelayOnFailure=" + this.getRefreshDelayOnFailure() + ", numberOfRetryOnFailure=" + this.getNumberOfRetryOnFailure() + ", cantDecipherStatusCode=" + this.getCantDecipherStatusCode() + ", passthroughRegex=" + this.getPassthroughRegex() + ", cache=" + this.getCache() + ", clock=" + this.getClock() + ", authToken=" + this.getAuthToken() + ", scheduledExecutorService=" + this.getScheduledExecutorService() + ", compiledPassthroughRegex=" + this.getCompiledPassthroughRegex() + ", shouldRetry=" + this.getShouldRetry() + ")";
    }

    public static class AuthRequest {
        @JsonbProperty(value="role_id")
        private String roleId;
        @JsonbProperty(value="secret_id")
        private String secretId;

        public String getRoleId() {
            return this.roleId;
        }

        public String getSecretId() {
            return this.secretId;
        }

        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthRequest)) {
                return false;
            }
            AuthRequest other = (AuthRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$roleId = this.getRoleId();
            String other$roleId = other.getRoleId();
            if (this$roleId == null ? other$roleId != null : !this$roleId.equals(other$roleId)) {
                return false;
            }
            String this$secretId = this.getSecretId();
            String other$secretId = other.getSecretId();
            return !(this$secretId == null ? other$secretId != null : !this$secretId.equals(other$secretId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AuthRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $roleId = this.getRoleId();
            result = result * 59 + ($roleId == null ? 43 : $roleId.hashCode());
            String $secretId = this.getSecretId();
            result = result * 59 + ($secretId == null ? 43 : $secretId.hashCode());
            return result;
        }

        public String toString() {
            return "VaultClient.AuthRequest(roleId=" + this.getRoleId() + ", secretId=" + this.getSecretId() + ")";
        }

        public AuthRequest() {
        }

        public AuthRequest(String roleId, String secretId) {
            this.roleId = roleId;
            this.secretId = secretId;
        }
    }

    public static class AuthResponse {
        private Auth auth;

        public Auth getAuth() {
            return this.auth;
        }

        public void setAuth(Auth auth) {
            this.auth = auth;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthResponse)) {
                return false;
            }
            AuthResponse other = (AuthResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Auth this$auth = this.getAuth();
            Auth other$auth = other.getAuth();
            return !(this$auth == null ? other$auth != null : !((Object)this$auth).equals(other$auth));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AuthResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Auth $auth = this.getAuth();
            result = result * 59 + ($auth == null ? 43 : ((Object)$auth).hashCode());
            return result;
        }

        public String toString() {
            return "VaultClient.AuthResponse(auth=" + this.getAuth() + ")";
        }
    }

    public static class Auth {
        private boolean renewable;
        @JsonbProperty(value="lease_duration")
        private long leaseDuration;
        @JsonbProperty(value="client_token")
        private String clientToken;

        public boolean isRenewable() {
            return this.renewable;
        }

        public long getLeaseDuration() {
            return this.leaseDuration;
        }

        public String getClientToken() {
            return this.clientToken;
        }

        public void setRenewable(boolean renewable) {
            this.renewable = renewable;
        }

        public void setLeaseDuration(long leaseDuration) {
            this.leaseDuration = leaseDuration;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Auth)) {
                return false;
            }
            Auth other = (Auth)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRenewable() != other.isRenewable()) {
                return false;
            }
            if (this.getLeaseDuration() != other.getLeaseDuration()) {
                return false;
            }
            String this$clientToken = this.getClientToken();
            String other$clientToken = other.getClientToken();
            return !(this$clientToken == null ? other$clientToken != null : !this$clientToken.equals(other$clientToken));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Auth;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRenewable() ? 79 : 97);
            long $leaseDuration = this.getLeaseDuration();
            result = result * 59 + (int)($leaseDuration >>> 32 ^ $leaseDuration);
            String $clientToken = this.getClientToken();
            result = result * 59 + ($clientToken == null ? 43 : $clientToken.hashCode());
            return result;
        }

        public String toString() {
            return "VaultClient.Auth(renewable=" + this.isRenewable() + ", leaseDuration=" + this.getLeaseDuration() + ", clientToken=" + this.getClientToken() + ")";
        }
    }

    private static class Authentication {
        private final Auth auth;
        private final long expiresAt;

        public Authentication(Auth auth, long expiresAt) {
            this.auth = auth;
            this.expiresAt = expiresAt;
        }

        public Auth getAuth() {
            return this.auth;
        }

        public long getExpiresAt() {
            return this.expiresAt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Authentication)) {
                return false;
            }
            Authentication other = (Authentication)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpiresAt() != other.getExpiresAt()) {
                return false;
            }
            Auth this$auth = this.getAuth();
            Auth other$auth = other.getAuth();
            return !(this$auth == null ? other$auth != null : !((Object)this$auth).equals(other$auth));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Authentication;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expiresAt = this.getExpiresAt();
            result = result * 59 + (int)($expiresAt >>> 32 ^ $expiresAt);
            Auth $auth = this.getAuth();
            result = result * 59 + ($auth == null ? 43 : ((Object)$auth).hashCode());
            return result;
        }

        public String toString() {
            return "VaultClient.Authentication(auth=" + this.getAuth() + ", expiresAt=" + this.getExpiresAt() + ")";
        }
    }

    public static class DecryptRequest {
        @JsonbProperty(value="batch_input")
        private Collection<DecryptInput> batchInput;

        public Collection<DecryptInput> getBatchInput() {
            return this.batchInput;
        }

        public void setBatchInput(Collection<DecryptInput> batchInput) {
            this.batchInput = batchInput;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DecryptRequest)) {
                return false;
            }
            DecryptRequest other = (DecryptRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<DecryptInput> this$batchInput = this.getBatchInput();
            Collection<DecryptInput> other$batchInput = other.getBatchInput();
            return !(this$batchInput == null ? other$batchInput != null : !((Object)this$batchInput).equals(other$batchInput));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DecryptRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<DecryptInput> $batchInput = this.getBatchInput();
            result = result * 59 + ($batchInput == null ? 43 : ((Object)$batchInput).hashCode());
            return result;
        }

        public String toString() {
            return "VaultClient.DecryptRequest(batchInput=" + this.getBatchInput() + ")";
        }

        public DecryptRequest() {
        }

        public DecryptRequest(Collection<DecryptInput> batchInput) {
            this.batchInput = batchInput;
        }
    }

    public static class DecryptResponse {
        private DecryptData data;

        public DecryptData getData() {
            return this.data;
        }

        public void setData(DecryptData data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DecryptResponse)) {
                return false;
            }
            DecryptResponse other = (DecryptResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DecryptData this$data = this.getData();
            DecryptData other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DecryptResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DecryptData $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "VaultClient.DecryptResponse(data=" + this.getData() + ")";
        }
    }

    public static class DecryptData {
        @JsonbProperty(value="batch_results")
        private Collection<DecryptResult> batchResults;

        public Collection<DecryptResult> getBatchResults() {
            return this.batchResults;
        }

        public void setBatchResults(Collection<DecryptResult> batchResults) {
            this.batchResults = batchResults;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DecryptData)) {
                return false;
            }
            DecryptData other = (DecryptData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<DecryptResult> this$batchResults = this.getBatchResults();
            Collection<DecryptResult> other$batchResults = other.getBatchResults();
            return !(this$batchResults == null ? other$batchResults != null : !((Object)this$batchResults).equals(other$batchResults));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DecryptData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<DecryptResult> $batchResults = this.getBatchResults();
            result = result * 59 + ($batchResults == null ? 43 : ((Object)$batchResults).hashCode());
            return result;
        }

        public String toString() {
            return "VaultClient.DecryptData(batchResults=" + this.getBatchResults() + ")";
        }
    }

    public static class DecryptResult {
        private String plaintext;
        private String context;
        private String error;

        public String getPlaintext() {
            return this.plaintext;
        }

        public String getContext() {
            return this.context;
        }

        public String getError() {
            return this.error;
        }

        public void setPlaintext(String plaintext) {
            this.plaintext = plaintext;
        }

        public void setContext(String context) {
            this.context = context;
        }

        public void setError(String error) {
            this.error = error;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DecryptResult)) {
                return false;
            }
            DecryptResult other = (DecryptResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$plaintext = this.getPlaintext();
            String other$plaintext = other.getPlaintext();
            if (this$plaintext == null ? other$plaintext != null : !this$plaintext.equals(other$plaintext)) {
                return false;
            }
            String this$context = this.getContext();
            String other$context = other.getContext();
            if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            return !(this$error == null ? other$error != null : !this$error.equals(other$error));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DecryptResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $plaintext = this.getPlaintext();
            result = result * 59 + ($plaintext == null ? 43 : $plaintext.hashCode());
            String $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : $context.hashCode());
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            return result;
        }

        public String toString() {
            return "VaultClient.DecryptResult(plaintext=" + this.getPlaintext() + ", context=" + this.getContext() + ", error=" + this.getError() + ")";
        }
    }

    public static class DecryptInput {
        private String ciphertext;
        private String context;
        private String nonce;

        public String getCiphertext() {
            return this.ciphertext;
        }

        public String getContext() {
            return this.context;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setCiphertext(String ciphertext) {
            this.ciphertext = ciphertext;
        }

        public void setContext(String context) {
            this.context = context;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DecryptInput)) {
                return false;
            }
            DecryptInput other = (DecryptInput)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$ciphertext = this.getCiphertext();
            String other$ciphertext = other.getCiphertext();
            if (this$ciphertext == null ? other$ciphertext != null : !this$ciphertext.equals(other$ciphertext)) {
                return false;
            }
            String this$context = this.getContext();
            String other$context = other.getContext();
            if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
                return false;
            }
            String this$nonce = this.getNonce();
            String other$nonce = other.getNonce();
            return !(this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DecryptInput;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ciphertext = this.getCiphertext();
            result = result * 59 + ($ciphertext == null ? 43 : $ciphertext.hashCode());
            String $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : $context.hashCode());
            String $nonce = this.getNonce();
            result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
            return result;
        }

        public String toString() {
            return "VaultClient.DecryptInput(ciphertext=" + this.getCiphertext() + ", context=" + this.getContext() + ", nonce=" + this.getNonce() + ")";
        }

        public DecryptInput() {
        }

        public DecryptInput(String ciphertext, String context, String nonce) {
            this.ciphertext = ciphertext;
            this.context = context;
            this.nonce = nonce;
        }
    }

    private static class EntryWithIndex<T> {
        private final int index;
        private final T entry;

        public EntryWithIndex(int index, T entry) {
            this.index = index;
            this.entry = entry;
        }
    }
}

