/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.components.vault.jcache;

import java.util.concurrent.TimeUnit;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.talend.sdk.components.vault.configuration.Documentation;
import org.talend.sdk.components.vault.jcache.CacheSizeManager;

@ApplicationScoped
public class CacheConfigurationFactory {
    @Inject
    @Documentation(value="Should JCache MBeans be registered.")
    @ConfigProperty(name="talend.vault.cache.jcache.cache.management", defaultValue="false")
    private Boolean cacheManagement;
    @Inject
    @Documentation(value="Should JCache statistics be enabled.")
    @ConfigProperty(name="talend.vault.cache.jcache.cache.statistics", defaultValue="false")
    private Boolean cacheStatistics;
    @Inject
    @Documentation(value="JCache expiry for decrypted values (ms).")
    @ConfigProperty(name="talend.vault.cache.jcache.cache.expiry", defaultValue="3600")
    private Long cacheExpiry;
    @Inject
    @Documentation(value="JCache max size per cache.")
    @ConfigProperty(name="talend.vault.cache.jcache.maxCacheSize", defaultValue="100000")
    private Integer maxCacheSize;

    public <K, T> Configuration<K, T> createConfiguration(CacheSizeManager<K, T> listener) {
        return new MutableConfiguration().setStoreByValue(false).setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, this.cacheExpiry.longValue()))).setManagementEnabled(this.cacheManagement.booleanValue()).setStatisticsEnabled(this.cacheStatistics.booleanValue()).addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)new MutableCacheEntryListenerConfiguration((Factory)new FactoryBuilder.SingletonFactory(listener), null, false, false));
    }

    public int maxSize() {
        return this.maxCacheSize;
    }
}

