/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven.docker;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.talend.sdk.component.maven.thread.MavenThreadFactory;

public class JibHelper
implements AutoCloseable {
    private final Log log;
    private final String tempDir;
    private final File layersCacheDirectory;
    private final String repository;
    private final Map<String, String> dockerEnvironment;
    private final File dockerExecutable;
    private final int laggyPushWorkaround;
    private final ExecutorService executor = Executors.newCachedThreadPool(new MavenThreadFactory(this.getClass().getName()));
    private JibContainerBuilder builder;
    private String tag;
    private String imageName;
    private String image;
    private AbsoluteUnixPath workingDirectory;
    private Instant creationTime;

    public void prepare(String artifactId, String projectVersion, Properties projectProperties, String fromImage, String toImage, String createTime, String workDir, Supplier<String> fallbackWorkingDir, Map<String, String> environment, Map<String, String> labels) throws InvalidImageReferenceException {
        if (this.builder != null) {
            throw new IllegalStateException("prepare had already been called");
        }
        this.builder = Jib.from((ImageReference)ImageReference.parse((String)fromImage));
        this.creationTime = createTime == null || createTime.trim().isEmpty() ? Instant.now() : Instant.parse(createTime);
        this.builder.setCreationTime(this.creationTime);
        this.workingDirectory = AbsoluteUnixPath.get((String)(workDir == null ? fallbackWorkingDir.get() : workDir));
        this.builder.setWorkingDirectory(this.workingDirectory);
        if (environment != null) {
            this.builder.setEnvironment(environment);
        }
        this.tag = projectVersion.endsWith("-SNAPSHOT") ? projectVersion.replace("-SNAPSHOT", "") + "_" + Optional.ofNullable(projectProperties.getProperty("git.branch")).map(it -> it.replace('/', '_') + "_").orElse("") + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) : projectVersion;
        this.image = toImage == null ? artifactId : toImage;
        this.imageName = (String)(this.repository == null || this.repository.trim().isEmpty() ? "" : this.repository + "/") + this.image + ":" + this.tag;
        if (labels != null) {
            this.builder.setLabels(labels.entrySet().stream().peek(it -> it.setValue(((String)it.getValue()).replace("@imageName@", this.imageName))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
    }

    public void build(String toolName, Supplier<Server> credentialsSupplier) throws InvalidImageReferenceException, InterruptedException, ExecutionException, IOException, CacheDirectoryCreationException, RegistryException, MojoExecutionException {
        if (this.builder == null) {
            throw new IllegalStateException("prepare had not been called");
        }
        if (this.repository != null) {
            Server credentials = credentialsSupplier.get();
            if (this.laggyPushWorkaround > 0) {
                this.toLocalDocker(this.executor, this.builder, this.tag, this.imageName, toolName);
                this.hackyPush(this.tag, this.repository, this.imageName, credentials);
            } else {
                RegistryImage registryImage = RegistryImage.named((String)this.imageName);
                if (credentials != null) {
                    registryImage.addCredential(credentials.getUsername(), credentials.getPassword());
                }
                this.builder.containerize(this.configureContainer(Containerizer.to((RegistryImage)registryImage), this.executor, "Talend Singer Maven Plugin"));
                this.log.info((CharSequence)("Pushed image='" + this.imageName + "', tag='" + this.tag + "'"));
            }
        } else {
            this.toLocalDocker(this.executor, this.builder, this.tag, this.imageName, toolName);
        }
    }

    public Containerizer configureContainer(Containerizer to, ExecutorService executor, String toolName) {
        return to.setExecutorService(executor).setApplicationLayersCache(this.layersCacheDirectory.toPath()).setBaseImageLayersCache(this.layersCacheDirectory.toPath()).setToolName(toolName);
    }

    public void toLocalDocker(ExecutorService executor, JibContainerBuilder builder, String tag, String imageName, String toolName) throws InvalidImageReferenceException, InterruptedException, ExecutionException, IOException, CacheDirectoryCreationException, RegistryException {
        DockerDaemonImage docker = DockerDaemonImage.named((String)imageName);
        if (this.dockerEnvironment != null) {
            docker.setDockerEnvironment(this.dockerEnvironment);
        }
        if (this.dockerExecutable != null) {
            docker.setDockerExecutable(this.dockerExecutable.toPath());
        }
        builder.containerize(this.configureContainer(Containerizer.to((DockerDaemonImage)docker), executor, toolName));
        this.log.info((CharSequence)("Built local image='" + imageName + "', tag='" + tag + "'"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hackyPush(String tag, String repository, String imageName, Server credentials) throws IOException, InterruptedException, MojoExecutionException {
        this.log.warn((CharSequence)"Using push workaround for nasty registries (using exec directly on 'docker'), it is highly recommended to not use laggyPushWorkaround configuration if you can");
        if (credentials != null) {
            File credFile = new File(this.tempDir, "talend-component-docker-credentials.temp");
            credFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(credFile);){
                writer.write(credentials.getPassword());
            }
            try {
                ProcessBuilder processBuilder = new ProcessBuilder("docker", "login", repository, "--username", credentials.getUsername(), "--password-stdin");
                processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
                processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                processBuilder.redirectInput(ProcessBuilder.Redirect.from(credFile));
                int exitCode = processBuilder.start().waitFor();
                if (exitCode != 0) {
                    this.log.warn((CharSequence)("Can't login, got status: " + exitCode));
                }
            }
            finally {
                if (!credFile.delete()) {
                    credFile.deleteOnExit();
                }
            }
        }
        boolean ok = false;
        for (int i = 0; i < this.laggyPushWorkaround; ++i) {
            int exit = new ProcessBuilder("docker", "push", imageName).inheritIO().start().waitFor();
            if (exit == 0) {
                ok = true;
                this.log.info((CharSequence)("Pushed image='" + imageName + "', tag='" + tag + "'"));
                break;
            }
            this.log.warn((CharSequence)("Push #" + (i + 1) + " got " + exit + " exit status"));
        }
        if (!ok) {
            throw new MojoExecutionException("Push didn't succeed");
        }
    }

    public void setProperties(MavenProject project, String versionProperty) {
        String repo = this.repository == null ? "" : this.repository;
        project.getProperties().put(versionProperty, this.imageName);
        project.getProperties().put(versionProperty + ".repository", repo);
        project.getProperties().put(versionProperty + ".repositoryPrefixed", repo.isEmpty() ? "" : repo + "/");
        project.getProperties().put(versionProperty + ".image", this.image);
        project.getProperties().put(versionProperty + ".version", this.tag);
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    @Generated
    public JibHelper(Log log, String tempDir, File layersCacheDirectory, String repository, Map<String, String> dockerEnvironment, File dockerExecutable, int laggyPushWorkaround) {
        this.log = log;
        this.tempDir = tempDir;
        this.layersCacheDirectory = layersCacheDirectory;
        this.repository = repository;
        this.dockerEnvironment = dockerEnvironment;
        this.dockerExecutable = dockerExecutable;
        this.laggyPushWorkaround = laggyPushWorkaround;
    }

    @Generated
    public JibContainerBuilder getBuilder() {
        return this.builder;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public String getImageName() {
        return this.imageName;
    }

    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public AbsoluteUnixPath getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }
}

