/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.util.Optional;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.talend.sdk.component.maven.api.Audience;

public abstract class AudienceAwareMojo
extends AbstractMojo {
    @Parameter(readonly=true, defaultValue="${project.groupId}")
    private String groupId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.warnIfNotWrongAudience();
    }

    private void warnIfNotWrongAudience() {
        this.getAudience().map(Audience::value).filter(audience -> audience == Audience.Type.TALEND_INTERNAL).filter(ignored -> !this.groupId.startsWith("org.talend") && !this.groupId.startsWith("com.talend")).ifPresent(ignored -> this.getLog().warn((CharSequence)("You are using " + ((Object)((Object)this)).getClass().getSimpleName() + " Mojo, this is not intended to be used outside Talend internal projects scope.")));
    }

    private Optional<Audience> getAudience() {
        for (Class<?> current = ((Object)((Object)this)).getClass(); current != null; current = current.getSuperclass()) {
            Audience annotation = current.getAnnotation(Audience.class);
            if (annotation == null) continue;
            return Optional.of(annotation);
        }
        return Optional.empty();
    }
}

