/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.util.Locale;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.talend.sdk.component.maven.ClasspathMojoBase;
import org.talend.sdk.component.maven.api.Audience;
import org.talend.sdk.component.tools.ComponentValidator;

@Audience(value=Audience.Type.PUBLIC)
@Mojo(name="validate", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class ValidateComponentMojo
extends ClasspathMojoBase {
    @Parameter(defaultValue="false", property="talend.validation.placeholder")
    private boolean validatePlaceholder;
    @Parameter(defaultValue="true", property="talend.validation.svg")
    private boolean validateSvg;
    @Parameter(defaultValue="true", property="talend.validation.family")
    private boolean validateFamily;
    @Parameter(defaultValue="true", property="talend.validation.serializable")
    private boolean validateSerializable;
    @Parameter(defaultValue="true", property="talend.validation.internationalization")
    private boolean validateInternationalization;
    @Parameter(defaultValue="true", property="talend.validation.model")
    private boolean validateModel;
    @Parameter(defaultValue="true", property="talend.validation.metadata")
    private boolean validateMetadata;
    @Parameter(defaultValue="true", property="talend.validation.component")
    private boolean validateComponent;
    @Parameter(defaultValue="true", property="talend.validation.datastore")
    private boolean validateDataStore;
    @Parameter(defaultValue="true", property="talend.validation.dataset")
    private boolean validateDataSet;
    @Parameter(defaultValue="true", property="talend.validation.action")
    private boolean validateActions;
    @Parameter(defaultValue="true", property="talend.validation.documentation")
    private boolean validateDocumentation;
    @Parameter(defaultValue="false", property="talend.validation.wording")
    private boolean validateWording;
    @Parameter(defaultValue="true", property="talend.validation.layout")
    private boolean validateLayout;
    @Parameter(defaultValue="true", property="talend.validation.options")
    private boolean validateOptionNames;
    @Parameter(defaultValue="true", property="talend.validation.validateOutputConnection")
    private boolean validateOutputConnection;
    @Parameter(defaultValue="true", property="talend.validation.localConfiguration")
    private boolean validateLocalConfiguration;
    @Parameter(defaultValue="true", property="talend.validation.noFinalOption")
    private boolean validateNoFinalOption;
    @Parameter(defaultValue="true", property="talend.validation.exceptions")
    private boolean validateExceptions;
    @Parameter(defaultValue="false", property="talend.validation.failOnValidateExceptions")
    private boolean failOnValidateExceptions;
    @Parameter(defaultValue="true", property="talend.validation.record")
    private boolean validateRecord;
    @Parameter(defaultValue="true", property="talend.validation.schema")
    private boolean validateSchema;
    @Parameter(defaultValue="${project.artifactId}", property="talend.validation.pluginId")
    private String pluginId;
    @Parameter(defaultValue="${project.artifactId}", property="talend.validation.locale")
    private String locale;

    @Override
    public void doExecute() {
        if (!this.validatePlaceholder) {
            this.getLog().warn((CharSequence)"You don't validate placeholders are set, maybe think about setting validatePlaceholder=true");
        }
        if (!this.validateWording) {
            this.getLog().warn((CharSequence)"You don't validate wording rules, maybe think about setting validateWording=true");
        }
        ComponentValidator.Configuration configuration = new ComponentValidator.Configuration();
        configuration.setValidateFamily(this.validateFamily);
        configuration.setValidateSerializable(this.validateSerializable);
        configuration.setValidateInternationalization(this.validateInternationalization);
        configuration.setValidateModel(this.validateModel);
        configuration.setValidateMetadata(this.validateMetadata);
        configuration.setValidateComponent(this.validateComponent);
        configuration.setValidateDataStore(this.validateDataStore);
        configuration.setValidateDataSet(this.validateDataSet);
        configuration.setValidateActions(this.validateActions);
        configuration.setValidateDocumentation(this.validateDocumentation);
        configuration.setValidateLayout(this.validateLayout);
        configuration.setValidateOptionNames(this.validateOptionNames);
        configuration.setValidateLocalConfiguration(this.validateLocalConfiguration);
        configuration.setValidateOutputConnection(this.validateOutputConnection);
        configuration.setValidatePlaceholder(this.validatePlaceholder);
        configuration.setValidateSvg(this.validateSvg);
        configuration.setValidateNoFinalOption(this.validateNoFinalOption);
        configuration.setValidateWording(this.validateWording);
        configuration.setPluginId(this.pluginId);
        configuration.setValidateExceptions(this.validateExceptions);
        configuration.setFailOnValidateExceptions(this.failOnValidateExceptions);
        configuration.setValidateSchema(this.validateSchema);
        configuration.setValidateRecord(this.validateRecord);
        final Locale locale = this.locale == null || "root".equals(this.locale) ? Locale.ROOT : new Locale(this.locale);
        new ComponentValidator(configuration, new File[]{this.classes}, this.getLog()){

            protected Locale getLocale() {
                return locale;
            }
        }.run();
    }
}

