/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.maven.ClasspathMojoBase;
import org.talend.sdk.component.maven.api.Audience;
import org.talend.sdk.component.tools.DitaDocumentationGenerator;

@Audience(value=Audience.Type.TALEND_INTERNAL)
@Mojo(name="dita", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class DitaMojo
extends ClasspathMojoBase {
    @Parameter(defaultValue="${project.build.directory}/${project.artifactId}-${project.version}-dita.zip", property="talend.dita.output")
    private String output;
    @Parameter(property="talend.dita.attach", defaultValue="true")
    private boolean attach;
    @Parameter(property="talend.dita.locales", defaultValue="en")
    private Collection<String> locales;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="talend.dita.transitive.dependencies")
    private Collection<String> includedDependencies;
    @Parameter(property="talend.dita.excludes")
    private Collection<String> excludes;
    @Parameter(property="talend.excludes")
    private Collection<String> sharedExcludes;
    @Parameter(property="talend.dita.ignoreTypeColumn", defaultValue="true")
    private boolean ignoreTypeColumn;
    @Parameter(property="talend.dita.ignorePathColumn", defaultValue="true")
    private boolean ignorePathColumn;
    @Component
    private MavenProjectHelper helper;

    @Override
    public void doExecute() {
        if (this.locales == null) {
            return;
        }
        this.locales.stream().map(Locale::new).map(locale -> {
            String localeStr = locale.toString();
            File output = new File(String.format(this.output, localeStr.isEmpty() ? "" : "_" + localeStr));
            final List<String> exclusions = this.getExcludes(this.excludes, this.sharedExcludes);
            new DitaDocumentationGenerator(this.getClasses(), (Locale)locale, this.getLog(), output, this.ignoreTypeColumn, this.ignorePathColumn){

                protected Stream<Class<?>> findComponents(AnnotationFinder finder) {
                    return super.findComponents(finder).filter(it -> !exclusions.contains(it.getName()));
                }
            }.run();
            return output;
        }).filter(it -> this.attach).forEach(artifact -> {
            String artifactName = artifact.getName();
            int dot = artifactName.lastIndexOf(95);
            if (dot < 0) {
                dot = artifactName.lastIndexOf(46);
            }
            this.getLog().info((CharSequence)("Attaching " + artifact.getAbsolutePath()));
            if (dot > 0) {
                this.helper.attachArtifact(this.project, "zip", artifactName.substring(dot + 1).replace('.', '-') + "-documentation", artifact);
            } else {
                this.helper.attachArtifact(this.project, "zip", artifactName + "-documentation", artifact);
            }
        });
    }

    private File[] getClasses() {
        return (File[])(this.includedDependencies == null ? Stream.of(this.classes) : Stream.concat(Stream.of(this.classes), this.getJarToScan(this.includedDependencies))).toArray(File[]::new);
    }
}

