/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.util.Map;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.talend.sdk.component.maven.DependencyAwareMojo;
import org.talend.sdk.component.maven.api.Audience;
import org.talend.sdk.component.tools.CarBundler;

@Audience(value=Audience.Type.PUBLIC)
@Mojo(name="car", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class CarMojo
extends DependencyAwareMojo {
    @Parameter(defaultValue="${project.packaging}")
    private String packaging;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.car", property="talend.car.output")
    private File output;
    @Parameter(defaultValue="true", property="talend.car.attach")
    private boolean attach;
    @Parameter(defaultValue="component", property="talend.car.classifier")
    private String classifier;
    @Parameter
    private Map<String, String> metadata;
    @Parameter(defaultValue="false", property="talend.car.skip")
    private boolean skip;
    @Component
    private MavenProjectHelper helper;

    public void execute() throws MojoFailureException {
        if (this.skip) {
            return;
        }
        if ("pom".equals(this.packaging)) {
            this.getLog().info((CharSequence)"Skipping car creation since the packaging is of type pom");
            return;
        }
        CarBundler.Configuration configuration = new CarBundler.Configuration();
        configuration.setMainGav(this.mainGav());
        configuration.setOutput(this.output);
        configuration.setArtifacts(this.artifacts());
        configuration.setVersion(this.project.getVersion());
        configuration.setCustomMetadata(this.metadata);
        new CarBundler(configuration, (Object)this.getLog()).run();
        if (this.attach) {
            this.helper.attachArtifact(this.project, "car", this.classifier, this.output);
            this.getLog().info((CharSequence)("Attached " + this.output + " with classifier " + this.classifier));
        }
    }
}

