/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.maven.ClasspathMojoBase;
import org.talend.sdk.component.maven.api.Audience;
import org.talend.sdk.component.tools.AsciidocDocumentationGenerator;

@Audience(value=Audience.Type.PUBLIC)
@Mojo(name="asciidoc", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class AsciidocMojo
extends ClasspathMojoBase {
    @Parameter(defaultValue="${project.version}", property="talend.documentation.version")
    private String version;
    @Parameter(defaultValue="2", property="talend.documentation.level")
    private int level;
    @Parameter(defaultValue="${project.build.outputDirectory}/TALEND-INF/documentation%s.adoc", property="talend.documentation.output")
    private String output;
    @Parameter(property="talend.documentation.formats")
    private Map<String, String> formats;
    @Parameter(property="talend.documentation.attributes")
    private Map<String, String> attributes;
    @Parameter(property="talend.documentation.templateDir")
    private File templateDir;
    @Parameter(property="talend.documentation.templateEngine")
    private String templateEngine;
    @Parameter(property="talend.documentation.title")
    private String title;
    @Parameter(property="talend.documentation.htmlAndPdf", defaultValue="false")
    private boolean htmlAndPdf;
    @Parameter(property="talend.documentation.attach", defaultValue="true")
    private boolean attachDocumentations;
    @Parameter(property="talend.documentation.workdDir", defaultValue="${project.build.directory}/talend-component/workdir")
    private File workDir;
    @Parameter(property="talend.documentation.locales", defaultValue="<root>")
    private Collection<String> locales;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="talend.documentation.transitive.dependencies")
    private Collection<String> includedDependencies;
    @Parameter(property="talend.documentation.excludes")
    protected Collection<String> excludes;
    @Parameter(property="talend.excludes")
    protected Collection<String> sharedExcludes;
    @Component
    private MavenProjectHelper helper;

    @Override
    public void doExecute() {
        if (this.locales == null || this.locales.isEmpty()) {
            this.getLog().warn((CharSequence)"No locale set, skipping documentation generation");
            return;
        }
        String title = this.title == null ? Optional.ofNullable(this.project.getName()).orElse(this.project.getArtifactId()) : this.title;
        List<File> adocs = this.locales.stream().map(it -> "<root>".equals(it) ? Locale.ROOT : new Locale((String)it)).flatMap(locale -> {
            String localeStr = locale.toString();
            final File output = new File(String.format(this.output, localeStr.isEmpty() ? "" : "_" + localeStr));
            Map<String, String> formats = this.htmlAndPdf ? new HashMap<String, String>(){
                {
                    this.put("html", new File(output.getParentFile(), output.getName().replace(".adoc", ".html")).getAbsolutePath());
                    this.put("pdf", new File(output.getParentFile(), output.getName().replace(".adoc", ".pdf")).getAbsolutePath());
                }
            } : this.formats;
            final List<String> exclusions = this.getExcludes(this.excludes, this.sharedExcludes);
            new AsciidocDocumentationGenerator(this.getClasses(), output, title, this.level, formats, this.attributes, this.templateDir, this.templateEngine, this.getLog(), this.workDir, this.version, (Locale)locale){

                protected Stream<Class<?>> findComponents(AnnotationFinder finder) {
                    return super.findComponents(finder).filter(it -> !exclusions.contains(it.getName()));
                }
            }.run();
            return formats == null || formats.isEmpty() ? Stream.of(output) : Stream.concat(Stream.of(output), formats.values().stream().map(File::new));
        }).collect(Collectors.toList());
        if (this.attachDocumentations) {
            adocs.forEach(artifact -> {
                String artifactName = artifact.getName();
                int dot = artifactName.lastIndexOf(95);
                if (dot < 0) {
                    dot = artifactName.lastIndexOf(46);
                }
                this.getLog().info((CharSequence)("Attaching " + artifact.getAbsolutePath()));
                if (dot > 0) {
                    this.helper.attachArtifact(this.project, "adoc", artifactName.substring(dot + 1).replace('.', '-') + "-documentation", artifact);
                } else {
                    this.helper.attachArtifact(this.project, "adoc", artifactName + "-documentation", artifact);
                }
            });
        }
    }

    private File[] getClasses() {
        return (File[])(this.includedDependencies == null ? Stream.of(this.classes) : Stream.concat(Stream.of(this.classes), this.getJarToScan(this.includedDependencies))).toArray(File[]::new);
    }
}

