/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.util.Collection;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.talend.sdk.component.maven.api.Audience;
import org.talend.sdk.component.tools.WebServer;

@Audience(value=Audience.Type.PUBLIC)
@Mojo(name="web", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class WebMojo
extends AbstractMojo {
    @Parameter
    private Collection<String> serverArguments;
    @Parameter(property="talend.web.port", defaultValue="8080")
    private Integer port;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter
    private UiConfiguration uiConfiguration;
    @Parameter(defaultValue="true", property="talend.web.openBrowser")
    private boolean openBrowser;

    public void execute() {
        String originalRepoSystProp = System.getProperty("talend.component.server.maven.repository");
        System.setProperty("talend.component.server.maven.repository", this.settings.getLocalRepository());
        if (this.uiConfiguration != null) {
            if (this.uiConfiguration.getCssLocation() == null || this.uiConfiguration.getJsLocation() == null) {
                throw new IllegalArgumentException("Either don't set <uiConfiguration /> or set js AND css locations");
            }
            System.setProperty("talend.tools.web.ui.js", this.uiConfiguration.getJsLocation());
            System.setProperty("talend.tools.web.ui.css", this.uiConfiguration.getCssLocation());
        }
        try {
            WebServer webServer = new WebServer(this.serverArguments, this.port, (Object)this.getLog(), String.format("%s:%s:%s", this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()));
            if (this.openBrowser) {
                webServer.openBrowserWhenReady();
            }
            webServer.run();
        }
        finally {
            if (originalRepoSystProp == null) {
                System.clearProperty("talend.component.server.maven.repository");
            } else {
                System.setProperty("talend.component.server.maven.repository", originalRepoSystProp);
            }
            System.clearProperty("talend.tools.web.ui.js");
            System.clearProperty("talend.tools.web.ui.css");
        }
    }

    public static class UiConfiguration {
        @Parameter(property="talend.web.ui.jsLocation")
        private String jsLocation;
        @Parameter(property="talend.web.ui.cssLocation")
        private String cssLocation;

        public String getJsLocation() {
            return this.jsLocation;
        }

        public String getCssLocation() {
            return this.cssLocation;
        }

        public void setJsLocation(String jsLocation) {
            this.jsLocation = jsLocation;
        }

        public void setCssLocation(String cssLocation) {
            this.cssLocation = cssLocation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UiConfiguration)) {
                return false;
            }
            UiConfiguration other = (UiConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jsLocation = this.getJsLocation();
            String other$jsLocation = other.getJsLocation();
            if (this$jsLocation == null ? other$jsLocation != null : !this$jsLocation.equals(other$jsLocation)) {
                return false;
            }
            String this$cssLocation = this.getCssLocation();
            String other$cssLocation = other.getCssLocation();
            return !(this$cssLocation == null ? other$cssLocation != null : !this$cssLocation.equals(other$cssLocation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UiConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jsLocation = this.getJsLocation();
            result = result * 59 + ($jsLocation == null ? 43 : $jsLocation.hashCode());
            String $cssLocation = this.getCssLocation();
            result = result * 59 + ($cssLocation == null ? 43 : $cssLocation.hashCode());
            return result;
        }

        public String toString() {
            return "WebMojo.UiConfiguration(jsLocation=" + this.getJsLocation() + ", cssLocation=" + this.getCssLocation() + ")";
        }
    }
}

