/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public abstract class DependencyAwareMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.remoteProjectRepositories}")
    private List<RemoteRepository> remoteRepositories;
    @Parameter(defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repositorySystemSession;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue=",", property="talend.bundle.exclude.artifacts")
    private String excludeArtifactsFilter;
    @Parameter(defaultValue="-", property="talend.bundle.include.artifacts")
    private String includeExtraArtifacts;

    protected Artifact resolve(Artifact dep, String classifier, String type) {
        LocalRepositoryManager lrm = this.repositorySystemSession.getLocalRepositoryManager();
        DefaultArtifact artifact = new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), classifier, type, dep.getVersion());
        File location = new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalArtifact((Artifact)artifact));
        if (!location.exists()) {
            return this.resolve((Artifact)artifact);
        }
        return artifact.setFile(location);
    }

    protected Artifact resolve(Artifact art) {
        ArtifactRequest request = new ArtifactRequest().setArtifact(art).setRepositories(this.remoteRepositories);
        try {
            ArtifactResult result = this.repositorySystem.resolveArtifact(this.repositorySystemSession, request);
            if (result.isMissing()) {
                throw new IllegalStateException("Can't find " + art);
            }
            return result.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            this.getLog().error((CharSequence)e.getMessage());
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected Stream<org.apache.maven.artifact.Artifact> extraArtifacts(String pom) throws MojoFailureException {
        try {
            this.getLog().info((CharSequence)("Reading extra dependencies from " + pom));
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)new FileReader(pom));
            MavenProject project = new MavenProject(model);
            List dependencies = project.getDependencies();
            return dependencies.stream().map(d -> this.resolve((Artifact)new DefaultArtifact(String.format("%s:%s:%s", d.getGroupId(), d.getArtifactId(), d.getVersion())), d.getClassifier(), "jar")).map(dep -> {
                org.apache.maven.artifact.DefaultArtifact ae = new org.apache.maven.artifact.DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), "runtime", "jar", Optional.ofNullable(dep.getClassifier()).orElse(""), (ArtifactHandler)new DefaultArtifactHandler());
                ae.setFile(dep.getFile());
                this.getLog().info((CharSequence)("Adding extra artifact " + ae + " to car file."));
                return ae;
            });
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
    }

    protected Map<String, File> artifacts() throws MojoFailureException {
        Predicate<String> excluded = test -> Arrays.stream(this.excludeArtifactsFilter.split(",")).filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).anyMatch(s -> {
            if (test.startsWith((String)s)) {
                this.getLog().info((CharSequence)("Removing artifact " + test + " from car file due to filter " + s + "."));
                return true;
            }
            return false;
        });
        Stream<Object> extraArtifacts = Stream.empty();
        if (!"-".equals(this.includeExtraArtifacts)) {
            extraArtifacts = this.extraArtifacts(this.includeExtraArtifacts);
        }
        Map<String, File> artifacts = Stream.concat(this.project.getArtifacts().stream().filter(a -> !"org.talend.sdk.component".equals(a.getGroupId()) && ("compile".equals(a.getScope()) || "runtime".equals(a.getScope())) && !excluded.test(String.format("%s:%s:%s", a.getGroupId(), a.getArtifactId(), a.getVersion()))), extraArtifacts).collect(Collectors.toMap(a -> String.format("%s:%s:%s%s:%s:%s", a.getGroupId(), a.getArtifactId(), Optional.ofNullable(a.getType()).orElse("jar"), a.getClassifier() == null || a.getClassifier().isEmpty() ? "" : ":" + a.getClassifier(), this.getVersion((org.apache.maven.artifact.Artifact)a), Optional.ofNullable(a.getScope()).orElse("compile")), org.apache.maven.artifact.Artifact::getFile, (a1, a2) -> {
            this.getLog().info((CharSequence)(a1 + " already exists " + a2));
            return a1;
        }));
        String mainGav = this.mainGav();
        artifacts.putIfAbsent(mainGav, new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "." + ("bundle".equals(this.project.getPackaging()) ? "jar" : this.project.getPackaging())));
        return artifacts;
    }

    private String getVersion(org.apache.maven.artifact.Artifact a) {
        return Optional.ofNullable(a.getBaseVersion()).orElseGet(() -> ((org.apache.maven.artifact.Artifact)a).getVersion());
    }

    protected String mainGav() {
        return String.format("%s:%s:%s", this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
    }
}

