/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.talend.sdk.component.maven.BuildComponentM2RepositoryMojo;
import org.talend.sdk.component.maven.api.Audience;
import org.talend.sdk.component.tools.webapp.standalone.generator.StaticUiSpecGenerator;

@Audience(value=Audience.Type.TALEND_INTERNAL)
@Mojo(name="uispec", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class UiSpecGeneratorMojo
extends BuildComponentM2RepositoryMojo {
    @Parameter(defaultValue="en")
    private Collection<String> languages;
    @Parameter(defaultValue="${maven.multiModuleProjectDirectory}/target/talend-component-kit/uispec.zip")
    private File uiSpecZip;
    @Component
    private MavenProjectHelper helper;

    @Override
    public void doExecute() throws MojoExecutionException {
        super.doExecute();
        HashMap<String, String> setup = new HashMap<String, String>();
        setup.put("talend.component.server.maven.repository", this.m2Root.getAbsolutePath());
        setup.put("talend.component.server.component.registry", this.getRegistry().getAbsolutePath());
        setup.put("talend.component.server.component.extend.dependencies", "false");
        new StaticUiSpecGenerator(setup, this.languages, this.uiSpecZip.toPath()).run();
        this.helper.attachArtifact(this.project, "zip", "uispec", this.uiSpecZip);
    }
}

