/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class Freemarkers {
    private final Map<String, Template> templates = new HashMap<String, Template>();
    private final String base;

    public Freemarkers(String base) {
        this.base = base;
    }

    public String templatize(String template, Map<String, Object> context) {
        Template tpl = this.templates.computeIfAbsent(template, tplName -> {
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_26);
            cfg.setDefaultEncoding("UTF-8");
            cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            cfg.setLogTemplateExceptions(false);
            cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(Freemarkers.class.getClassLoader(), this.base));
            try {
                return cfg.getTemplate(tplName + ".ftlh");
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        });
        StringWriter writer = new StringWriter();
        try {
            tpl.process(context, (Writer)writer);
        }
        catch (TemplateException | IOException e) {
            throw new IllegalStateException(e);
        }
        writer.flush();
        return writer.toString();
    }
}

