/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.ziplock.Files;
import org.apache.ziplock.IO;
import org.eclipse.aether.artifact.Artifact;
import org.talend.sdk.component.maven.ComponentDependenciesBase;
import org.talend.sdk.component.maven.api.Audience;

@Audience(value=Audience.Type.TALEND_INTERNAL)
@Mojo(name="prepare-repository", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class BuildComponentM2RepositoryMojo
extends ComponentDependenciesBase {
    @Parameter(property="talend-m2.registryBase")
    private File componentRegistryBase;
    @Parameter(property="talend-m2.root", defaultValue="${maven.multiModuleProjectDirectory}/target/talend-component-kit/maven")
    protected File m2Root;
    @Parameter(property="talend-m2.clean", defaultValue="true")
    private boolean cleanBeforeGeneration;
    @Parameter(defaultValue="component", property="talend.car.classifier")
    private String classifier;

    @Override
    public void doExecute() throws MojoExecutionException {
        Set<Artifact> componentArtifacts = this.getComponentsCar(this.getComponentArtifacts());
        if (this.cleanBeforeGeneration && this.m2Root.exists()) {
            Files.remove((File)this.m2Root);
        }
        this.m2Root.mkdirs();
        List<String> coordinates = componentArtifacts.stream().map(car -> this.copyComponentDependencies((Artifact)car, (entry, read) -> this.copyFile((ZipEntry)entry, (InputStream)read, entry.getName().substring("MAVEN-INF/repository/".length())))).filter(Objects::nonNull).distinct().sorted().collect(Collectors.toList());
        if (this.getLog().isDebugEnabled()) {
            coordinates.forEach(it -> this.getLog().debug((CharSequence)("Including component " + it)));
        } else {
            this.getLog().info((CharSequence)("Included components " + String.join((CharSequence)", ", coordinates)));
        }
        this.writeRegistry(this.getNewComponentRegistry(coordinates));
        this.getLog().info((CharSequence)("Created component repository at " + this.m2Root));
    }

    protected void writeRegistry(Properties components) {
        try (FileWriter output = new FileWriter(this.getRegistry());){
            components.store(output, "Generated by Talend Component Kit " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected File copyFile(ZipEntry entry, InputStream read, String depPath) {
        File file = new File(this.m2Root, depPath);
        Files.mkdir((File)file.getParentFile());
        try {
            IO.copy((InputStream)read, (File)file);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        long lastModified = entry.getTime();
        if (lastModified > 0L) {
            file.setLastModified(lastModified);
        }
        return file;
    }

    protected Properties getNewComponentRegistry(List<String> coordinates) {
        Properties components = new Properties();
        if (this.componentRegistryBase != null && this.componentRegistryBase.exists()) {
            try (FileInputStream source = new FileInputStream(this.componentRegistryBase);){
                components.load(source);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        coordinates.stream().filter(it -> it.contains(":")).forEach(it -> components.put(it.split(":")[1], it.trim()));
        return components;
    }

    protected String copyComponentDependencies(Artifact car, BiConsumer<ZipEntry, InputStream> onDependency) {
        String gav = null;
        try (ZipInputStream read = new ZipInputStream(new BufferedInputStream(new FileInputStream(car.getFile())));){
            ZipEntry entry;
            while ((entry = read.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String path = entry.getName();
                if ("TALEND-INF/metadata.properties".equals(path)) {
                    Properties properties = new Properties();
                    properties.load(read);
                    gav = properties.getProperty("component_coordinates").replace("\\:", "");
                    continue;
                }
                if (!path.startsWith("MAVEN-INF/repository/")) continue;
                onDependency.accept(entry, read);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return gav;
    }

    protected Set<Artifact> getComponentsCar(Set<Artifact> artifacts) {
        return artifacts.stream().map(art -> this.resolve((Artifact)art, this.classifier, "car")).collect(Collectors.toSet());
    }

    protected Set<Artifact> getComponentArtifacts() {
        return this.getArtifacts(it -> {
            try (JarFile file = new JarFile(it.getFile());){
                Artifact artifact = Optional.ofNullable(file.getEntry("TALEND-INF/dependencies.txt")).map(ok -> it).orElse(null);
                return artifact;
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected File getRegistry() {
        return new File(this.m2Root, "component-registry.properties");
    }
}

