/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="talend-component")
public class TalendLifecycleExtension
extends AbstractMavenLifecycleParticipant {
    public void afterProjectsRead(MavenSession session) {
        Properties properties;
        PluginExecution documentation;
        PluginExecution dependencies;
        List executions;
        Optional<Plugin> plugin = session.getCurrentProject().getBuild().getPlugins().stream().filter(p -> "org.talend.sdk.component".equals(p.getGroupId()) && "talend-component-maven-plugin".equals(p.getArtifactId())).findFirst();
        if (plugin.isPresent()) {
            executions = plugin.get().getExecutions();
        } else {
            Plugin def = new Plugin();
            def.setGroupId("org.talend.sdk.component");
            def.setArtifactId("talend-component-maven-plugin");
            def.setVersion("1.1.27");
            session.getCurrentProject().getBuild().getPlugins().add(def);
            executions = def.getExecutions();
        }
        if (this.isExecutionMissing(executions, "svg2png")) {
            dependencies = new PluginExecution();
            dependencies.setId("talend-svg2png");
            dependencies.addGoal("svg2png");
            dependencies.setPhase("process-classes");
            executions.add(dependencies);
        }
        if (this.isExecutionMissing(executions, "validate")) {
            PluginExecution validate = new PluginExecution();
            validate.setId("talend-validate");
            validate.addGoal("validate");
            validate.setPhase("process-classes");
            executions.add(validate);
        }
        if (this.isExecutionMissing(executions, "dependencies")) {
            dependencies = new PluginExecution();
            dependencies.setId("talend-dependencies");
            dependencies.addGoal("dependencies");
            dependencies.setPhase("process-classes");
            executions.add(dependencies);
        }
        if (this.isExecutionMissing(executions, "scan-descriptor")) {
            dependencies = new PluginExecution();
            dependencies.setId("talend-scan-descriptor");
            dependencies.addGoal("scan-descriptor");
            dependencies.setPhase("process-classes");
            executions.add(dependencies);
        }
        if (this.isExecutionMissing(executions, "asciidoc")) {
            documentation = new PluginExecution();
            documentation.setId("talend-asciidoc");
            documentation.addGoal("asciidoc");
            documentation.setPhase("process-classes");
            executions.add(documentation);
        }
        if (this.isExecutionMissing(executions, "car")) {
            documentation = new PluginExecution();
            documentation.setId("talend-car");
            documentation.addGoal("car");
            documentation.setPhase("package");
            executions.add(documentation);
        }
        if ((properties = session.getCurrentProject().getProperties()) != null && Boolean.parseBoolean(properties.getProperty("talend.component.extension.singer.active", "false")) && this.isExecutionMissing(executions, "singer")) {
            PluginExecution documentation2 = new PluginExecution();
            documentation2.setId("talend-singer");
            documentation2.addGoal("singer");
            documentation2.setPhase("package");
            executions.add(documentation2);
        }
    }

    private boolean isExecutionMissing(List<PluginExecution> executions, String goal) {
        return executions.stream().noneMatch(e -> e.getGoals() != null && e.getGoals().contains(goal));
    }
}

