/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.talend.sdk.component.maven.AudienceAwareMojo;
import org.talend.sdk.component.maven.api.Audience;

@Audience(value=Audience.Type.TALEND_INTERNAL)
public abstract class ComponentDependenciesBase
extends AudienceAwareMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="talend-m2.scopes", defaultValue="compile,runtime")
    private List<String> scopes;
    @Parameter(property="talend-m2.packagings", defaultValue="jar,bundle")
    private List<String> packagings;
    @Parameter(defaultValue="false", property="talend.skip")
    private boolean skip;
    @Parameter(defaultValue="${repositorySystemSession}")
    protected RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}")
    private List<RemoteRepository> remoteRepositories;
    @Component
    private RepositorySystem repositorySystem;

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution skipped");
            return;
        }
        super.execute();
        this.doExecute();
    }

    protected <T> Stream<T> getArtifacts(Function<Artifact, T> onArtifact) {
        return this.project.getDependencies().stream().filter(art -> this.scopes.contains(art.getScope())).filter(dep -> this.packagings.contains(dep.getType())).map(dep -> new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier(), dep.getType(), dep.getVersion())).map(dep -> this.resolve((Artifact)dep, dep.getClassifier(), "jar")).map(art -> {
            try (JarFile file = new JarFile(art.getFile());){
                Object var4_5 = Optional.ofNullable(file.getEntry("TALEND-INF/dependencies.txt")).map(entry -> {
                    try (InputStream stream = file.getInputStream((ZipEntry)entry);){
                        Object r = onArtifact.apply((Artifact)art);
                        return r;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }).orElse(null);
                return var4_5;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    protected Artifact resolve(Artifact dep, String classifier, String type) {
        LocalRepositoryManager lrm = this.repositorySystemSession.getLocalRepositoryManager();
        DefaultArtifact artifact = new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), classifier, type, this.getVersion(dep));
        File location = new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalArtifact((Artifact)artifact));
        if (!location.exists()) {
            return this.resolve((Artifact)artifact);
        }
        return artifact.setFile(location);
    }

    private String getVersion(Artifact dep) {
        return Optional.ofNullable(dep.getBaseVersion()).orElseGet(() -> ((Artifact)dep).getVersion());
    }

    protected Artifact resolve(Artifact art) {
        ArtifactRequest artifactRequest = new ArtifactRequest().setArtifact(art).setRepositories(this.remoteRepositories);
        try {
            ArtifactResult result = this.repositorySystem.resolveArtifact(this.repositorySystemSession, artifactRequest);
            if (result.isMissing()) {
                throw new IllegalStateException("Can't find " + art);
            }
            return result.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

