/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.io.FileUtils;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.maven.Freemarkers;

@Mojo(name="generate")
public class ComponentGeneratorMojo
extends AbstractMojo {
    @Parameter(property="talend.generator.classbase")
    private String classnameBase;
    @Parameter(property="talend.generator.type", defaultValue="help", required=true)
    private String type;
    @Parameter(property="talend.generator.family")
    private String family;
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File baseDir;
    @Parameter(defaultValue="${project.build.sourceDirectory}", readonly=true)
    private File sourceDir;
    @Parameter(defaultValue="  ", property="talend.generator.pom.spacing")
    private String pomUnitarySpacing;
    @Parameter(defaultValue="UTF-8", property="talend.generator.pom.encoding")
    private String pomEncoding;
    @Parameter(defaultValue="UTF-8", property="talend.generator.pom.read-only")
    private boolean pomReadOnly;
    private final Freemarkers freemarkers = new Freemarkers(((Object)((Object)this)).getClass().getSimpleName());

    public void execute() throws MojoExecutionException, MojoFailureException {
        switch (this.type.toLowerCase(Locale.ENGLISH)) {
            case "input": {
                this.initGenerationState();
                this.generateInput();
                this.enforceApiInPom();
                break;
            }
            case "output": {
                this.initGenerationState();
                this.generateOutput();
                this.enforceApiInPom();
                break;
            }
            default: {
                this.getLog().info((CharSequence)"Available generator types:");
                this.getLog().info((CharSequence)"- input: generates a source component");
                this.getLog().info((CharSequence)"- output: generates a sink component");
            }
        }
    }

    private void enforceApiInPom() {
        if (this.pomReadOnly) {
            this.getLog().debug((CharSequence)"Pom is in read only mode, skipping any modification");
            return;
        }
        File pomXml = new File(this.baseDir, "pom.xml");
        if (!pomXml.isFile()) {
            this.getLog().warn((CharSequence)("Didn't find " + pomXml + ", you can need to add component-api dependency yourself"));
            return;
        }
        try {
            String content = FileUtils.fileRead((File)pomXml);
            if (content.contains("<artifactId>component-api</artifactId>")) {
                this.getLog().debug((CharSequence)("component-api already in " + pomXml));
                return;
            }
            String dependency = ("    <dependency>\n      <groupId>org.talend.sdk.component</groupId>      <artifactId>component-api</artifactId>      <version>" + Service.class.getPackage().getImplementationVersion() + "</version>    </dependency>\n").replace("  ", this.pomUnitarySpacing);
            int dependencies = content.indexOf("<dependencies>");
            if (dependencies < 0) {
                int end = content.indexOf("</project>");
                if (end < 0) {
                    throw new IllegalArgumentException(pomXml + " appears invalid, no </project> tag");
                }
                content = content.substring(0, end) + "\n" + this.pomUnitarySpacing + "<dependencies>\n" + dependency + this.pomUnitarySpacing + "</dependencies>\n" + content.substring(end);
            } else {
                int depStartEnd = dependencies + "<dependencies>".length();
                content = content.substring(0, depStartEnd) + '\n' + dependency + content.substring(depStartEnd, content.length());
            }
            FileUtils.fileWrite((File)pomXml, (String)this.pomEncoding, (String)content);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void initGenerationState() {
        if (this.classnameBase == null) {
            this.classnameBase = org.apache.maven.shared.utils.StringUtils.capitalise((String)Stream.of(StringUtils.splitByCharacterTypeCamelCase((String)this.baseDir.getName())).collect(Collectors.joining("")));
        }
        if (!this.classnameBase.contains(".")) {
            Optional<File> child;
            List<String> stopFolders = Arrays.asList("input", "output");
            File current = this.sourceDir;
            while (current.exists() && (child = Optional.ofNullable(current.listFiles((dir, name) -> new File(dir, name).isDirectory() && !name.startsWith("."))).filter(f -> ((File[])f).length == 1).map(f -> f[0])).isPresent() && !stopFolders.contains(child.get().getName())) {
                current = child.get();
            }
            String base = this.sourceDir.toPath().relativize(current.toPath()).toString().replace(File.separatorChar, '/').replace('/', '.');
            String packageBase = base + (base.isEmpty() ? "" : ".") + this.type.replace('-', '_');
            this.classnameBase = packageBase + '.' + this.classnameBase;
        }
        if (this.family == null) {
            this.family = Stream.of(StringUtils.splitByCharacterTypeCamelCase((String)this.baseDir.getName().replace("components", "").replace("component", ""))).collect(Collectors.joining(""));
        }
    }

    private File createOutputFile(File sourceDir, String child) {
        File file = new File(sourceDir, child);
        if (file.exists()) {
            throw new IllegalStateException(file + " exists, maybe configure the classnameBase of the generator");
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IllegalStateException(file + " parent directory can't be created");
        }
        this.getLog().info((CharSequence)("Creating " + file));
        return file;
    }

    private void generateOutput() {
        String classPath = this.classnameBase.replace('.', '/') + "Output.java";
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(this.createOutputFile(this.sourceDir, classPath)));){
            ((OutputStream)stream).write(this.freemarkers.templatize("output", this.createContext("Output")).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        File i18n = new File(this.createOutputFile(this.sourceDir.getParentFile(), "resources/" + classPath).getParentFile(), "Messages.properties");
        String name = this.classnameBase.substring(this.classnameBase.lastIndexOf(46) + 1);
        this.appendI18n(i18n, this.family + '.' + name + "Output._displayName", name);
    }

    private void generateInput() {
        String classPath = this.classnameBase.replace('.', '/');
        Stream.of("mapper", "emitter").forEach(tpl -> {
            String template = org.apache.maven.shared.utils.StringUtils.capitalise((String)tpl);
            try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(this.createOutputFile(this.sourceDir, classPath + template + ".java")));){
                ((OutputStream)stream).write(this.freemarkers.templatize("input-" + tpl, this.createContext(template)).getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
        File i18n = new File(new File(this.sourceDir.getParentFile(), "resources/" + classPath).getParentFile(), "Messages.properties");
        String name = this.classnameBase.substring(this.classnameBase.lastIndexOf(46) + 1);
        this.appendI18n(i18n, this.family + '.' + name + "Mapper._displayName", name);
    }

    private void appendI18n(File i18n, String ... properties) {
        Properties existing;
        block31: {
            existing = new Properties();
            if (i18n.exists()) {
                try (FileReader reader = new FileReader(i18n);){
                    existing.load(reader);
                    break block31;
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException(ioe);
                }
            }
            if (!i18n.getParentFile().isDirectory() && !i18n.getParentFile().mkdirs()) {
                throw new IllegalArgumentException("Can't create " + i18n.getParentFile());
            }
        }
        Properties config = new Properties();
        for (int i = 0; i < properties.length; i += 2) {
            if (existing.containsKey(properties[i])) continue;
            config.setProperty(properties[i], properties[i + 1]);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(i18n));){
            writer.write("\n\n");
            config.store(writer, "generated while creating component " + this.classnameBase);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Map<String, Object> createContext(String template) {
        return Collections.singletonMap("configuration", this.doCreateConfiguration(template));
    }

    private Configuration doCreateConfiguration(String template) {
        if (this.classnameBase.contains(".")) {
            int lastDot = this.classnameBase.lastIndexOf(46);
            return new Configuration(this.family, this.classnameBase.substring(0, lastDot), this.classnameBase.substring(lastDot + 1, this.classnameBase.length()), template);
        }
        return new Configuration(this.family, "", this.classnameBase, template);
    }

    public static class Configuration {
        private final String family;
        private final String packageName;
        private final String className;
        private final String template;

        public String getFamily() {
            return this.family;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getTemplate() {
            return this.template;
        }

        public Configuration(String family, String packageName, String className, String template) {
            this.family = family;
            this.packageName = packageName;
            this.className = className;
            this.template = template;
        }
    }
}

