/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.talend.sdk.component.maven.ClasspathMojoBase;
import org.talend.sdk.component.tools.AsciidocDocumentationGenerator;

@Mojo(name="asciidoc", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class AsciidocMojo
extends ClasspathMojoBase {
    @Parameter(defaultValue="${project.version}", property="talend.documentation.version")
    private String version;
    @Parameter(defaultValue="2", property="talend.documentation.level")
    private int level;
    @Parameter(defaultValue="${project.build.outputDirectory}/TALEND-INF/documentation.adoc", property="talend.documentation.output")
    private File output;
    @Parameter(property="talend.documentation.formats")
    private Map<String, String> formats;
    @Parameter(property="talend.documentation.attributes")
    private Map<String, String> attributes;
    @Parameter(property="talend.documentation.templateDir")
    private File templateDir;
    @Parameter(property="talend.documentation.templateEngine")
    private String templateEngine;
    @Parameter(property="talend.documentation.title")
    private String title;
    @Parameter(property="talend.documentation.htmlAndPdf", defaultValue="false")
    private boolean htmlAndPdf;
    @Parameter(property="talend.documentation.attach", defaultValue="true")
    private boolean attachDocumentations;
    @Parameter(property="talend.documentation.workdDir", defaultValue="${project.build.directory}/talend-component/workdir")
    private File workDir;
    @Component
    private MavenProjectHelper helper;

    @Override
    public void doExecute() {
        Map<String, String> formats = this.htmlAndPdf ? new HashMap<String, String>(){
            {
                this.put("html", new File(AsciidocMojo.this.output.getParentFile(), AsciidocMojo.this.output.getName().replace(".adoc", ".html")).getAbsolutePath());
                this.put("pdf", new File(AsciidocMojo.this.output.getParentFile(), AsciidocMojo.this.output.getName().replace(".adoc", ".pdf")).getAbsolutePath());
            }
        } : this.formats;
        new AsciidocDocumentationGenerator(new File[]{this.classes}, this.output, this.title == null ? Optional.ofNullable(this.project.getName()).orElse(this.project.getArtifactId()) : this.title, this.level, (Map)formats, this.attributes, this.templateDir, this.templateEngine, (Object)this.getLog(), this.workDir, this.version).run();
        if (this.attachDocumentations) {
            Stream.concat(Stream.of(this.output), Optional.ofNullable(this.formats).map(m -> m.values().stream().map(File::new)).orElseGet(Stream::empty)).filter(File::exists).forEach(artifact -> {
                String artifactName = artifact.getName();
                int dot = artifactName.lastIndexOf(46);
                if (dot > 0) {
                    this.helper.attachArtifact(this.project, artifact, artifactName.substring(dot + 1, artifactName.length()) + "-documentation");
                } else {
                    this.helper.attachArtifact(this.project, artifact, artifactName + "-documentation");
                }
            });
        }
    }
}

