/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.xbean.finder.AnnotationFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class LayoutValidator
implements Validator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LayoutValidator.class);
    private final Validators.ValidatorHelper helper;

    public LayoutValidator(Validators.ValidatorHelper helper) {
        this.helper = helper;
    }

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        return components.stream().map(this.helper::buildOrGetParameters).flatMap(this::toFlatNonPrimitiveConfig).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, (p1, p2) -> p1)).entrySet().stream().flatMap(this::visitLayout);
    }

    private Stream<String> visitLayout(Map.Entry<String, ParameterMeta> config) {
        Stream<String> errorsLib;
        Set fieldsInGridLayout = config.getValue().getMetadata().entrySet().stream().filter(meta -> ((String)meta.getKey()).startsWith("tcomp::ui::gridlayout")).flatMap(meta -> Stream.of(((String)meta.getValue()).split("\\|"))).flatMap(s -> Stream.of(s.split(","))).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        Set fieldsInOptionOrder = config.getValue().getMetadata().entrySet().stream().filter(meta -> ((String)meta.getKey()).startsWith("tcomp::ui::optionsorder")).flatMap(meta -> Stream.of(((String)meta.getValue()).split(","))).collect(Collectors.toSet());
        if (fieldsInGridLayout.isEmpty() && fieldsInOptionOrder.isEmpty()) {
            return Stream.empty();
        }
        if (!fieldsInGridLayout.isEmpty() && !fieldsInOptionOrder.isEmpty()) {
            log.error("Concurrent layout found for '" + config.getKey() + "', the @OptionsOrder will be ignored.");
        }
        if (!fieldsInGridLayout.isEmpty()) {
            errorsLib = fieldsInGridLayout.stream().filter(fieldInLayout -> ((ParameterMeta)config.getValue()).getNestedParameters().stream().map(ParameterMeta::getName).noneMatch(field -> field.equals(fieldInLayout))).map(fieldInLayout -> "Option '" + fieldInLayout + "' in @GridLayout doesn't exist in declaring class '" + (String)config.getKey() + "'").sorted();
            config.getValue().getNestedParameters().stream().filter(field -> !fieldsInGridLayout.contains(field.getName())).map(field -> "Field '" + field.getName() + "' in " + (String)config.getKey() + " is not declared in any layout.").forEach(arg_0 -> ((Logger)log).error(arg_0));
        } else {
            errorsLib = fieldsInOptionOrder.stream().filter(fieldInLayout -> ((ParameterMeta)config.getValue()).getNestedParameters().stream().map(ParameterMeta::getName).noneMatch(field -> field.equals(fieldInLayout))).map(fieldInLayout -> "Option '" + fieldInLayout + "' in @OptionOrder doesn't exist in declaring class '" + (String)config.getKey() + "'").sorted();
            config.getValue().getNestedParameters().stream().filter(field -> !fieldsInOptionOrder.contains(field.getName())).map(field -> "Field '" + field.getName() + "' in " + (String)config.getKey() + " is not declared in any layout.").forEach(arg_0 -> ((Logger)log).error(arg_0));
        }
        return errorsLib;
    }

    private Stream<AbstractMap.SimpleEntry<String, ParameterMeta>> toFlatNonPrimitiveConfig(List<ParameterMeta> config) {
        if (config == null || config.isEmpty()) {
            return Stream.empty();
        }
        return config.stream().filter(Objects::nonNull).filter(p -> ParameterMeta.Type.OBJECT.equals((Object)p.getType()) || this.isArrayOfObject((ParameterMeta)p)).filter(p -> p.getNestedParameters() != null).flatMap(p -> Stream.concat(Stream.of(new AbstractMap.SimpleEntry<String, ParameterMeta>(this.toJavaType((ParameterMeta)p).getName(), (ParameterMeta)p)), this.toFlatNonPrimitiveConfig(p.getNestedParameters())));
    }

    private boolean isArrayOfObject(ParameterMeta param) {
        return ParameterMeta.Type.ARRAY.equals((Object)param.getType()) && param.getNestedParameters() != null && param.getNestedParameters().stream().anyMatch(p -> ParameterMeta.Type.OBJECT.equals((Object)p.getType()) || ParameterMeta.Type.ENUM.equals((Object)p.getType()) || this.isArrayOfObject((ParameterMeta)p));
    }

    private Class<?> toJavaType(ParameterMeta p) {
        if (p.getType().equals((Object)ParameterMeta.Type.OBJECT) || p.getType().equals((Object)ParameterMeta.Type.ENUM)) {
            if (Class.class.isInstance(p.getJavaType())) {
                return (Class)Class.class.cast(p.getJavaType());
            }
            throw new IllegalArgumentException("Unsupported type for parameter " + p.getPath() + " (from " + p.getSource().declaringClass() + "), ensure it is a Class<?>");
        }
        if (p.getType().equals((Object)ParameterMeta.Type.ARRAY) && ParameterizedType.class.isInstance(p.getJavaType())) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(p.getJavaType());
            Type[] arguments = parameterizedType.getActualTypeArguments();
            if (arguments.length == 1 && Class.class.isInstance(arguments[0])) {
                return (Class)Class.class.cast(arguments[0]);
            }
            throw new IllegalArgumentException("Unsupported type for parameter " + p.getPath() + " (from " + p.getSource().declaringClass() + "), ensure it is a ParameterizedType with one argument");
        }
        throw new IllegalStateException("Parameter '" + p.getName() + "' is not an object.");
    }
}

