/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.talend.sdk.component.tools.AsciidoctorExecutor;
import org.talend.sdk.component.tools.DocBaseGenerator;

public class AsciidocDocumentationGenerator
extends DocBaseGenerator {
    private final String levelPrefix;
    private final Map<String, String> formats;
    private final Map<String, String> attributes;
    private final File templateDir;
    private final File workDir;
    private final String templateEngine;
    private final String title;
    private final String version;

    public AsciidocDocumentationGenerator(File[] classes, File output, String title, int level, Map<String, String> formats, Map<String, String> attributes, File templateDir, String templateEngine, Object log, File workDir, String version, Locale locale) {
        super(classes, locale, log, output);
        this.title = title;
        this.formats = formats;
        this.attributes = attributes;
        this.templateDir = templateDir;
        this.templateEngine = templateEngine;
        this.workDir = workDir;
        this.version = version;
        this.levelPrefix = IntStream.range(0, level).mapToObj(i -> "=").collect(Collectors.joining(""));
    }

    @Override
    public void doRun() {
        String doc = this.components().map(this::toAsciidoc).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
        this.write(this.output, doc);
        this.log.info("Generated " + this.output.getAbsolutePath());
        this.renderAdoc();
    }

    private String toAsciidoc(DocBaseGenerator.ComponentDescription desc) {
        String partMarker = desc.getName();
        return "//component_start:" + partMarker + "\n\n" + this.levelPrefix + " " + desc.getName() + "\n\n" + desc.getDocumentation() + (String)(desc.getParameters().isEmpty() ? "" : "//configuration_start\n\n" + this.levelPrefix + "= Configuration\n\n" + desc.parameters().map(this::toAsciidoctor).collect(Collectors.joining("\n", "[cols=\"d,d,m,a,e,d\",options=\"header\"]\n|===\n|Display Name|Description|Default Value|Enabled If|Configuration Path|Configuration Type\n", "\n|===\n\n//configuration_end\n\n"))) + "//component_end:" + partMarker + "\n\n";
    }

    private String toAsciidoctor(DocBaseGenerator.Param p) {
        return "|" + p.getDisplayName() + "|" + p.getDocumentation() + "|" + p.getDefaultValue() + "|" + this.doRenderConditions(p.getConditions()) + "|" + p.getFullPath() + "|" + p.getType();
    }

    private String doRenderConditions(DocBaseGenerator.Conditions conditions) {
        switch (conditions.getConditions().size()) {
            case 0: {
                return "Always enabled";
            }
            case 1: {
                return this.renderCondition(conditions.getConditions().iterator().next());
            }
        }
        String conds = conditions.getConditions().stream().map(this::renderCondition).map(c -> "- " + c).collect(Collectors.joining("\n", "\n", "\n"));
        switch (conditions.getOperator().toUpperCase(Locale.ROOT)) {
            case "OR": {
                return "One of these conditions is meet:\n" + conds;
            }
        }
        return "All of the following conditions are met:\n" + conds;
    }

    private String renderCondition(DocBaseGenerator.Condition condition) {
        String values = Stream.of(condition.getValue().split(",")).map(v -> "`" + v + "`").collect(Collectors.joining(" or "));
        switch (Optional.ofNullable(condition.getStrategy()).orElse("default").toLowerCase(Locale.ROOT)) {
            case "length": {
                if (condition.isNegate()) {
                    if (values.equals("`0`")) {
                        return "`" + condition.getPath() + "` is not empty";
                    }
                    return "the length of `" + condition.getPath() + "` is not " + values;
                }
                if (values.equals("`0`")) {
                    return "`" + condition.getPath() + "` is empty";
                }
                return "the length of `" + condition.getPath() + "` is " + values;
            }
            case "contains": {
                if (condition.isNegate()) {
                    return "`" + condition.getPath() + "` does not contain " + values;
                }
                return "`" + condition.getPath() + "` contains " + values;
            }
            case "contains(lowercase=true)": {
                if (condition.isNegate()) {
                    return "the lowercase value of `" + condition.getPath() + "` does not contain " + values;
                }
                return "the lowercase value of `" + condition.getPath() + "` contains " + values;
            }
        }
        if (condition.isNegate()) {
            return "`" + condition.getPath() + "` is not equal to " + values;
        }
        return "`" + condition.getPath() + "` is equal to " + values;
    }

    private void renderAdoc() {
        try (AsciidoctorExecutor asciidoctorExecutor = new AsciidoctorExecutor();){
            Optional.ofNullable(this.formats).ifPresent(f -> f.forEach((format, output) -> {
                switch (format.toLowerCase(Locale.ENGLISH)) {
                    case "html": {
                        asciidoctorExecutor.render(this.workDir, this.version, this.log, "html5", this.output, new File((String)output), this.title, this.attributes, this.templateDir, this.templateEngine);
                        break;
                    }
                    case "pdf": {
                        asciidoctorExecutor.render(this.workDir, this.version, this.log, "pdf", this.output, new File((String)output), this.title, this.attributes, this.templateDir, this.templateEngine);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown format: '" + format + "', supported: [html, pdf]");
                    }
                }
            }));
        }
    }
}

