/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.exec;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CarMain {
    public static final String COMPONENT_JAVA_COORDINATES = "component.java.coordinates";
    public static final String COMPONENT_COORDINATES = "component_coordinates";
    public static final String COMPONENT_SERVER_EXTENSIONS = "component.server.extensions";
    public static final String UTF_8_ENC = "UTF-8";

    private CarMain() {
    }

    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            CarMain.help();
            return;
        }
        if (Stream.of(args).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("No argument can be null");
        }
        boolean forceOverwrite = false;
        for (String arg : args) {
            if (!"-f".equals(arg)) continue;
            forceOverwrite = true;
            break;
        }
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "studio-deploy": {
                String studioPath = args.length == 2 ? args[1] : CarMain.getArgument("--location", args);
                if (studioPath == null || studioPath.isEmpty()) {
                    System.err.println("Path to studio is not set. Use '--location <location>' to set it.");
                    CarMain.help();
                    break;
                }
                CarMain.deployInStudio(studioPath, forceOverwrite);
                break;
            }
            case "maven-deploy": {
                String mavenPath = args.length == 2 ? args[1] : CarMain.getArgument("--location", args);
                if (mavenPath == null || mavenPath.isEmpty()) {
                    System.err.println("Path to maven repository is not set. Use '--location <location>' to set it.");
                    CarMain.help();
                    break;
                }
                CarMain.deployInM2(mavenPath, forceOverwrite);
                break;
            }
            case "deploy-to-nexus": {
                String url = CarMain.getArgument("--url", args);
                String repo = CarMain.getArgument("--repo", args);
                String user = CarMain.getArgument("--user", args);
                String pass = CarMain.getArgument("--pass", args);
                String threads = CarMain.getArgument("--threads", args);
                int threadsNum = threads == null ? Runtime.getRuntime().availableProcessors() : Integer.parseInt(threads);
                String dir = CarMain.getArgument("--dir", args);
                if (url == null || url.isEmpty()) {
                    System.err.println("Nexus url is not set. Use '--url <url>' to set it");
                    CarMain.help();
                    break;
                }
                if (repo == null || repo.isEmpty()) {
                    System.err.println("Nexus repo is not set. Use '--repo <repository>' to set it");
                    CarMain.help();
                    break;
                }
                CarMain.deployToNexus(url, repo, user, pass, threadsNum, dir);
                break;
            }
            default: {
                CarMain.help();
                throw new IllegalArgumentException("Unknown command '" + args[0] + "'");
            }
        }
    }

    private static String getArgument(String argumentPrefix, String ... args) {
        for (int i = 1; i < args.length - 1; ++i) {
            if (!args[i].equals(argumentPrefix)) continue;
            return args[i + 1];
        }
        return null;
    }

    private static void deployInM2(String m2, boolean forceOverwrite) {
        File m2File = new File(m2);
        if (!m2File.exists()) {
            throw new IllegalArgumentException(m2 + " doesn't exist");
        }
        String component = CarMain.installJars(m2File, forceOverwrite).getProperty(COMPONENT_COORDINATES);
        System.out.println("Installed " + CarMain.jarLocation(CarMain.class).getName() + " in " + m2 + ", you can now register '" + component + "' component in your application.");
    }

    private static void deployInStudio(String studioLocation, boolean forceOverwrite) {
        String type;
        block25: {
            String repositoryType;
            System.out.println(String.format("Connector is being deployed to %s.", studioLocation));
            File root = new File(studioLocation);
            if (!root.isDirectory()) {
                throw new IllegalArgumentException(studioLocation + " is not a valid directory");
            }
            File config = new File(studioLocation, "configuration/config.ini");
            if (!config.exists()) {
                throw new IllegalArgumentException("No " + config + " found, is your studio location right?");
            }
            Properties configuration = CarMain.readProperties(config);
            String m2RepoPath = System.getProperty("talend.studio.m2.repo", null);
            File m2Root = m2RepoPath != null ? new File(m2RepoPath) : ("global".equals(repositoryType = configuration.getProperty("maven.repository")) ? Stream.of("TALEND_STUDIO_MAVEN_HOME", "MAVEN_HOME", "M2_HOME", "talend.component.server.maven.repository", "talend.studio.m2").map(it -> it.contains(".") ? System.getProperty(it) : System.getenv(it)).filter(Objects::nonNull).findFirst().map(mvnHome -> {
                File globalSettings = new File((String)mvnHome, "conf/settings.xml");
                if (globalSettings.exists()) {
                    try {
                        String repoPath;
                        Node node;
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        Document document = builder.parse(globalSettings);
                        NodeList localRepository = document.getElementsByTagName("localRepository");
                        if (localRepository.getLength() == 1 && (node = localRepository.item(0)) != null && (repoPath = node.getTextContent()) != null) {
                            return new File(repoPath);
                        }
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        throw new IllegalStateException(e);
                    }
                }
                return null;
            }).orElseGet(() -> new File(System.getProperty("user.home"), ".m2/repository/")) : new File(studioLocation, "configuration/.m2/repository/"));
            if (!m2Root.isDirectory()) {
                throw new IllegalArgumentException(m2Root + " does not exist, did you specify a valid m2 studio property?");
            }
            Properties carProperties = CarMain.installJars(m2Root, forceOverwrite);
            String mainGav = carProperties.getProperty(COMPONENT_COORDINATES);
            type = carProperties.getProperty("type", "connector");
            String key = "extension".equalsIgnoreCase(type) ? COMPONENT_SERVER_EXTENSIONS : COMPONENT_JAVA_COORDINATES;
            String components = configuration.getProperty(key);
            try {
                List<String> configLines = Files.readAllLines(config.toPath());
                if (components == null) {
                    String original = configLines.stream().collect(Collectors.joining("\n"));
                    try (FileWriter writer = new FileWriter(config);){
                        writer.write(original + "\n" + key + " = " + mainGav);
                        break block25;
                    }
                }
                File backup = new File(config.getParentFile(), "backup/" + config.getName() + "_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-mm-dd_HH-mm-ss")));
                backup.getParentFile().mkdirs();
                try (BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(backup));){
                    Files.copy(config.toPath(), to);
                }
                boolean skip = false;
                try (FileWriter writer = new FileWriter(config);){
                    for (String line : configLines) {
                        if (line.trim().startsWith(key)) {
                            skip = true;
                            continue;
                        }
                        if (skip && line.trim().contains("=")) {
                            skip = false;
                        } else if (skip) continue;
                        writer.write(line + "\n");
                    }
                    String toFilter = Stream.of(mainGav.contains(":") ? mainGav.split(":") : mainGav.split("/")).limit(2L).collect(Collectors.joining(":", "", ":"));
                    writer.write(key + " = " + Stream.concat(Stream.of(mainGav), Stream.of(components.trim().split(",")).map(String::trim).filter(it -> !it.isEmpty()).filter(it -> !it.startsWith(toFilter))).collect(Collectors.joining(",")));
                }
                System.out.println(type + " registered.");
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }
        System.out.println(type + " deployed successfully.");
    }

    private static Properties installJars(File m2Root, boolean forceOverwrite) {
        String mainGav = null;
        Properties properties = new Properties();
        try (JarInputStream jar = new JarInputStream(new BufferedInputStream(new FileInputStream(CarMain.jarLocation(CarMain.class))));){
            JarEntry entry;
            while ((entry = jar.getNextJarEntry()) != null) {
                if (entry.isDirectory()) continue;
                if (entry.getName().startsWith("MAVEN-INF/repository/")) {
                    String path = entry.getName().substring("MAVEN-INF/repository/".length());
                    File output = new File(m2Root, path);
                    if (!output.getCanonicalPath().startsWith(m2Root.getCanonicalPath())) {
                        throw new IOException("The output file is not contained in the destination directory");
                    }
                    if (output.exists() && !forceOverwrite) continue;
                    output.getParentFile().mkdirs();
                    Files.copy(jar, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                if (!"TALEND-INF/metadata.properties".equals(entry.getName())) continue;
                properties.load(jar);
                mainGav = properties.getProperty(COMPONENT_COORDINATES);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        if (mainGav == null || mainGav.trim().isEmpty()) {
            throw new IllegalArgumentException("Didn't find the component coordinates");
        }
        System.out.println(String.format("Connector %s and dependencies jars installed to %s.", mainGav, m2Root));
        return properties;
    }

    private static Properties readProperties(File config) {
        Properties configuration = new Properties();
        try (FileInputStream stream = new FileInputStream(config);){
            configuration.load(stream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return configuration;
    }

    private static void help() {
        System.err.println("Usage:\n\njava -jar " + CarMain.jarLocation(CarMain.class).getName() + " [command] [arguments]");
        System.err.println("commands:");
        System.err.println("   studio-deploy");
        System.err.println("      arguments:");
        System.err.println("         --location <location>: path to studio");
        System.err.println("         or");
        System.err.println("         <location>: path to studio");
        System.err.println("         -f : force overwrite existing jars");
        System.err.println();
        System.err.println("   maven-deploy");
        System.err.println("      arguments:");
        System.err.println("         --location <location>: path to .m2 repository");
        System.err.println("         or");
        System.err.println("         <location>: path to .m2 repository");
        System.err.println("         -f : force overwrite existing jars");
        System.err.println();
        System.err.println("   deploy-to-nexus");
        System.err.println("      arguments:");
        System.err.println("         --url <nexusUrl>: nexus server url");
        System.err.println("         --repo <repositoryName>: nexus repository name to upload dependencies to");
        System.err.println("         --user <username>: username to connect to nexus(optional)");
        System.err.println("         --pass <password>: password to connect to nexus(optional)");
        System.err.println("         --threads <parallelThreads>: threads number to use during upload to nexus(optional)");
        System.err.println("         --dir <tempDirectory>: temporary directory to use during upload(optional)");
    }

    private static File jarLocation(Class clazz) {
        try {
            String classFileName = clazz.getName().replace(".", "/") + ".class";
            ClassLoader loader = clazz.getClassLoader();
            return CarMain.jarFromResource(loader, classFileName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static File jarFromResource(ClassLoader loader, String resourceName) {
        try {
            URL url = loader.getResource(resourceName);
            if (url == null) {
                throw new IllegalStateException("didn't find " + resourceName);
            }
            if ("jar".equals(url.getProtocol())) {
                String spec = url.getFile();
                int separator = spec.indexOf(33);
                return new File(URLDecoder.decode(new URL(spec.substring(0, separator)).getFile(), UTF_8_ENC));
            }
            if ("file".equals(url.getProtocol())) {
                return CarMain.toFile(resourceName, url);
            }
            throw new IllegalArgumentException("Unsupported URL scheme: " + url.toExternalForm());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static File toFile(String classFileName, URL url) throws UnsupportedEncodingException {
        String path = url.getFile();
        return new File(URLDecoder.decode(path.substring(0, path.length() - classFileName.length()), UTF_8_ENC));
    }

    private static void deployToNexus(String serverUrl, String repositoryName, String username, String password, int parallelThreads, String tempDirLocation) {
        String mainGav = null;
        ArrayList<JarEntry> entriesToProcess = new ArrayList<JarEntry>();
        try (JarFile jar = new JarFile(CarMain.jarLocation(CarMain.class));){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                if (entry.getName().startsWith("MAVEN-INF/repository/")) {
                    entriesToProcess.add(entry);
                    continue;
                }
                if (!"TALEND-INF/metadata.properties".equals(entry.getName())) continue;
                Properties properties = new Properties();
                properties.load(jar.getInputStream(entry));
                mainGav = properties.getProperty(COMPONENT_COORDINATES);
            }
            if (mainGav == null || mainGav.trim().isEmpty()) {
                throw new IllegalArgumentException("Didn't find the component coordinates");
            }
            CarMain.uploadEntries(serverUrl, repositoryName, username, password, entriesToProcess, jar, parallelThreads, tempDirLocation);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        System.out.println("Installed " + CarMain.jarLocation(CarMain.class).getName() + " on " + serverUrl + ", you can now register '" + mainGav + "' component in your application.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadEntries(String serverUrl, String repositoryName, String username, String password, List<JarEntry> entriesToProcess, JarFile jar, int parallelThreads, String tempDirLocation) {
        File tempDirectory;
        if (entriesToProcess.isEmpty()) {
            return;
        }
        if (tempDirLocation == null || tempDirLocation.isEmpty()) {
            System.out.println("No temporary directory is set. Creating a new one...");
            try {
                tempDirectory = Files.createTempDirectory("car-deploy-to-nexus", new FileAttribute[0]).toFile();
            }
            catch (IOException e1) {
                String message = "Could not create temp directory: " + e1.getMessage();
                throw new UnsupportedOperationException(message, e1);
            }
        } else {
            tempDirectory = new File(tempDirLocation, "car-deploy-to-nexus-" + UUID.randomUUID().toString());
            tempDirectory.mkdirs();
            if (!(tempDirectory.exists() && tempDirectory.canWrite() && tempDirectory.canRead())) {
                throw new IllegalArgumentException("Cannot access temporary directory " + tempDirLocation);
            }
        }
        System.out.println(tempDirectory.getPath() + " will be used as temporary directory.");
        String basicAuth = CarMain.getAuthHeader(username, password);
        String nexusVersion = CarMain.getNexusVersion(serverUrl, username, password, basicAuth);
        ExecutorService executor = Executors.newFixedThreadPool(Math.min(entriesToProcess.size(), parallelThreads));
        try {
            CountDownLatch latch = new CountDownLatch(entriesToProcess.size());
            for (JarEntry entry : entriesToProcess) {
                String path = entry.getName().substring("MAVEN-INF/repository/".length());
                executor.execute(() -> {
                    try {
                        if (!CarMain.artifactExists(nexusVersion, serverUrl, basicAuth, repositoryName, path)) {
                            File extracted = CarMain.extractJar(tempDirectory, jar, entry);
                            CarMain.sendJar(nexusVersion, serverUrl, basicAuth, repositoryName, path, extracted);
                            CarMain.sendPom(nexusVersion, serverUrl, basicAuth, repositoryName, path, extracted);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("A problem occured while uploading artifact: " + e.getMessage());
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                System.err.println("Exception caught while awaiting for latch: " + e.getMessage());
            }
        }
        finally {
            executor.shutdown();
            try {
                executor.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted while awaiting for executor to shutdown.");
                Thread.currentThread().interrupt();
            }
            try {
                System.out.println("Removing " + tempDirectory.getPath());
                if (tempDirectory.exists()) {
                    CarMain.removeTempDirectoryRecursively(tempDirectory);
                }
            }
            catch (Exception e) {
                System.err.println("Couldn't remove " + tempDirectory.getPath() + ": " + e.getMessage());
            }
        }
    }

    private static void removeTempDirectoryRecursively(File file) {
        if (file.exists() && file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    CarMain.removeTempDirectoryRecursively(child);
                }
            }
            file.delete();
        }
    }

    private static File extractJar(File destDirectory, JarFile jar, JarEntry entry) throws IOException {
        File extracted;
        try (InputStream is = jar.getInputStream(entry);){
            String fileName = entry.getName().substring(entry.getName().lastIndexOf("/") + 1);
            extracted = File.createTempFile("temp-", fileName, destDirectory);
            Files.copy(is, extracted.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return extracted;
    }

    private static String getAuthHeader(String username, String password) {
        if (username == null || username.isEmpty()) {
            return null;
        }
        return "Basic " + Base64.getEncoder().encodeToString((username + (String)(password == null || password.isEmpty() ? "" : ":" + password)).getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean artifactExists(String nexusVersion, String serverUrl, String basicAuth, String repositoryName, String path) throws IOException {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(CarMain.getNexusUploadUrl(nexusVersion, serverUrl, repositoryName, path));
            conn = (HttpURLConnection)HttpURLConnection.class.cast(url.openConnection());
            conn.setDoOutput(true);
            conn.setRequestMethod("GET");
            if (basicAuth != null) {
                conn.setRequestProperty("Authorization", basicAuth);
            }
            conn.connect();
            if (conn.getResponseCode() == 404) {
                boolean bl = false;
                return bl;
            }
            if (conn.getResponseCode() == 401) {
                throw new IllegalArgumentException("Authentication failed!");
            }
            if (conn.getResponseCode() == 400) {
                System.out.println("Ignoring " + path + ", it is likely not deployed on the right repository.");
            } else {
                System.out.println("Artifact " + path + " already exists on " + serverUrl + ". Skipping.");
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return true;
    }

    private static void sendPom(String nexusVersion, String serverUrl, String basicAuth, String repositoryName, String path, File jarFile) throws IOException {
        String pomPath = CarMain.getPomPathFromPath(path);
        System.out.println("Path of pom file resolved: " + pomPath);
        try (JarFile jar = new JarFile(jarFile);){
            JarEntry entry = jar.getJarEntry(pomPath);
            if (entry == null) {
                throw new FileNotFoundException("Could not find " + pomPath + " inside " + jar.getName());
            }
            try (InputStream jarIs = jar.getInputStream(entry);){
                String serverPomPath = path.substring(0, path.lastIndexOf(".")) + ".pom";
                CarMain.sendData(nexusVersion, serverUrl, basicAuth, repositoryName, serverPomPath, jarIs);
            }
        }
    }

    private static String getPomPathFromPath(String path) {
        String parentPath = path.substring(0, path.lastIndexOf("/"));
        String version = parentPath.substring(parentPath.lastIndexOf("/") + 1);
        String fileName = path.substring(path.lastIndexOf("/") + 1);
        int versionIndex = fileName.indexOf(version);
        String artifactName = versionIndex > 0 ? fileName.substring(0, versionIndex - 1) : (fileName.endsWith(".jar") ? fileName.substring(0, fileName.length() - 4) : fileName);
        String group = parentPath.substring(0, parentPath.lastIndexOf(artifactName));
        if (group.startsWith("/")) {
            group = group.substring(1);
        }
        if (group.endsWith("/")) {
            group = group.substring(0, group.length() - 1);
        }
        group = group.replace("/", ".");
        return "META-INF/maven/" + group + "/" + artifactName + "/pom.xml";
    }

    private static void sendJar(String nexusVersion, String serverUrl, String basicAuth, String repositoryName, String path, File jarFile) throws IOException {
        try (FileInputStream is = new FileInputStream(jarFile);){
            CarMain.sendData(nexusVersion, serverUrl, basicAuth, repositoryName, path, is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendData(String nexusVersion, String serverUrl, String basicAuth, String repositoryName, String path, InputStream is) throws IOException {
        System.out.println("Uploading " + path + " to " + serverUrl);
        HttpURLConnection conn = null;
        try {
            URL url = new URL(CarMain.getNexusUploadUrl(nexusVersion, serverUrl, repositoryName, path));
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod(CarMain.getRequestMethod(nexusVersion));
            if (basicAuth != null) {
                conn.setRequestProperty("Authorization", basicAuth);
            }
            conn.setRequestProperty("Content-Type", "multipart/form-data");
            conn.setRequestProperty("Accept", "*/*");
            conn.connect();
            try (OutputStream out = conn.getOutputStream();){
                byte[] buffer = new byte[1024];
                int bytesRead = -1;
                while ((bytesRead = is.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                out.flush();
                if (conn.getResponseCode() != 201) {
                    throw new IOException(conn.getResponseCode() + " - " + conn.getResponseMessage());
                }
            }
            System.out.println(path + " Uploaded");
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static String getNexusUploadUrl(String nexusVersion, String serverUrl, String repositoryName, String path) {
        if (nexusVersion.equals("V2")) {
            return CarMain.getUploadUrl(serverUrl, "content/repositories", repositoryName, path);
        }
        if (nexusVersion.startsWith("V3")) {
            return CarMain.getUploadUrl(serverUrl, "repository", repositoryName, path);
        }
        throw new IllegalArgumentException("Unknown Nexus version: " + nexusVersion);
    }

    private static String getUploadUrl(String serverUrl, String repositoriesLocation, String repo, String path) {
        return serverUrl + (serverUrl.endsWith("/") ? "" : "/") + repositoriesLocation + "/" + repo + "/" + path;
    }

    private static String getNexusVersion(String serverUrl, String username, String password, String auth) {
        String version;
        System.out.println("Checking " + serverUrl + " API version.");
        if (CarMain.isV2(serverUrl, username, password, auth)) {
            version = "V2";
        } else if (CarMain.isStableV3(serverUrl, username, password, auth)) {
            version = "V3";
        } else if (CarMain.isBetaV3(serverUrl, username, password, auth)) {
            version = "V3Beta";
        } else {
            throw new UnsupportedOperationException("Provided url doesn't respond neither to Nexus 2 nor to Nexus 3 endpoints.");
        }
        System.out.println("Nexus API version is recognized as " + version);
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isV2(String serverUrl, String username, String password, String auth) {
        block15: {
            System.out.println("Checking for V2 version...");
            HttpURLConnection conn = null;
            try {
                conn = CarMain.prepareGet(serverUrl, username, password, "service/local/status", "*/*", auth);
                if (conn.getResponseCode() < 200 || conn.getResponseCode() > 299) break block15;
                try (InputStream is = conn.getInputStream();){
                    int read;
                    byte[] b = new byte[1024];
                    StringBuilder out = new StringBuilder();
                    while ((read = is.read(b, 0, b.length)) > 0) {
                        out.append(new String(b, 0, read));
                    }
                    if (out.toString().contains("\"apiVersion\":\"2.")) {
                        System.out.println("version is v2");
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        return false;
    }

    private static boolean isBetaV3(String serverUrl, String username, String password, String auth) {
        System.out.println("Checking for V3Beta version...");
        return CarMain.get(serverUrl, username, password, "service/rest/beta/repositories", auth);
    }

    private static boolean isStableV3(String serverUrl, String username, String password, String auth) {
        System.out.println("Checking for V3 version...");
        return CarMain.get(serverUrl, username, password, "service/rest/v1/repositories", auth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean get(String serverUrl, String username, String password, String path, String auth) {
        boolean passed = false;
        HttpURLConnection conn = null;
        try {
            conn = CarMain.prepareGet(serverUrl, username, password, path, "application/json", auth);
            if (conn.getResponseCode() == 200) {
                passed = true;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return passed;
    }

    private static HttpURLConnection prepareGet(String serverUrl, String username, String password, String path, String accept, String auth) throws IOException {
        URL url = new URL(serverUrl + (serverUrl.endsWith("/") ? "" : "/") + path);
        System.out.println("Sending GET request to " + url.getPath());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        String userpass = username + ":" + password;
        String basicAuth = "Basic " + Base64.getEncoder().encodeToString(userpass.getBytes());
        conn.setRequestMethod("GET");
        if (auth != null) {
            conn.setRequestProperty("Authorization", auth);
        }
        conn.setRequestProperty("Accept", accept);
        conn.connect();
        return conn;
    }

    private static String getRequestMethod(String nexusVersion) {
        if ("V2".equals(nexusVersion)) {
            return "POST";
        }
        if (nexusVersion.startsWith("V3")) {
            return "PUT";
        }
        throw new IllegalArgumentException("Unknown Nexus version: " + nexusVersion);
    }
}

