/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.ziplock.IO;
import org.apache.ziplock.JarLocation;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.jruby.internal.JRubyAsciidoctor;
import org.talend.sdk.component.path.PathFactory;
import org.talend.sdk.component.tools.Log;

public class AsciidoctorExecutor
implements AutoCloseable {
    private Asciidoctor asciidoctor;
    private File extractedResources;
    private Runnable onClose = () -> {};

    public static void main(String[] args) throws IOException {
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(args));
        try (AsciidoctorExecutor executor = new AsciidoctorExecutor();){
            if (params.contains("--continue")) {
                params.remove("--continue");
                String[] newArgs = params.toArray(new String[0]);
                while (true) {
                    executor.doMain(newArgs);
                    String line = System.console().readLine();
                    if (line == null || "exit".equalsIgnoreCase(line.trim())) {
                        return;
                    }
                    executor.doMain(newArgs);
                }
            }
            executor.doMain(args);
        }
    }

    public void doMain(String[] args) throws IOException {
        Path adoc = PathFactory.get((String)args[0]).toAbsolutePath();
        File output = adoc.getParent().resolve(args.length > 1 ? args[1] : args[0].replace(".adoc", ".pdf")).toFile();
        List lines = Files.lines(adoc).collect(Collectors.toList());
        String version = lines.stream().filter(it -> it.startsWith("v")).findFirst().map(it -> it.substring(1)).orElse(args.length > 2 ? args[2] : "");
        this.render(args.length > 3 ? new File(args[3]) : new File("target/pdf"), version, new Log(){

            @Override
            public void debug(String s) {
            }

            @Override
            public void error(String s) {
                System.err.println(s);
            }

            @Override
            public void info(String s) {
                System.out.println(s);
            }
        }, "pdf", adoc.toFile(), output, lines.stream().filter(it -> it.startsWith("= ")).findFirst().orElseGet(() -> args.length > 4 ? args[4] : "Document"), new HashMap<String, String>(), args.length > 6 ? new File(args[6]) : null, args.length > 7 ? args[7] : null, args.length > 5 ? args[5] : null);
    }

    public void render(File workDir, String version, Log log, String backend, File source, File output, String title, Map<String, String> attributes, File templateDir, String templateEngine) {
        this.render(workDir, version, log, backend, source, output, title, attributes, templateDir, templateEngine, null);
    }

    private void render(File workDir, String version, Log log, String backend, File source, File output, String title, Map<String, String> attributes, File templateDir, String templateEngine, String libraries) {
        log.info("Rendering '" + source.getName() + "' to '" + output + "'");
        if (this.asciidoctor == null) {
            this.asciidoctor = this.getAsciidoctor();
            if (libraries != null) {
                Stream.of(libraries.split(",")).map(String::trim).filter(s -> !s.isEmpty()).forEach(xva$0 -> this.asciidoctor.requireLibrary(new String[]{xva$0}));
            }
        }
        OptionsBuilder optionsBuilder = OptionsBuilder.options().baseDir(source.getParentFile()).toFile(output).backend(backend).safe(SafeMode.UNSAFE).docType("book").mkDirs(true);
        AttributesBuilder attrs = AttributesBuilder.attributes().attributeMissing("skip").attributeUndefined("drop");
        if (attributes == null) {
            this.configureDefaultsAttributes(workDir, log, backend, attrs, Collections.emptyMap());
        } else {
            attributes.forEach((k, v) -> {
                if (v == null) {
                    attrs.attribute(k);
                } else {
                    attrs.attribute(k, v);
                }
            });
            this.configureDefaultsAttributes(workDir, log, backend, attrs, attributes);
        }
        optionsBuilder.attributes(attrs);
        Optional.ofNullable(templateDir).ifPresent(arg_0 -> ((OptionsBuilder)optionsBuilder).templateDir(arg_0));
        Optional.ofNullable(templateEngine).ifPresent(arg_0 -> ((OptionsBuilder)optionsBuilder).templateEngine(arg_0));
        log.debug("Options: " + optionsBuilder.asMap());
        this.asciidoctor.convert(this.wrap(title, version, source), optionsBuilder);
    }

    private void configureDefaultsAttributes(File workDir, Log log, String backend, AttributesBuilder attrs, Map<String, String> attributes) {
        if (this.extractedResources == null) {
            this.extractResources(workDir, log);
        }
        switch (backend.toLowerCase(Locale.ENGLISH)) {
            case "html": 
            case "html5": {
                if (!attributes.containsKey("stylesheet")) {
                    attrs.attribute("stylesheet", (Object)"talend.css");
                }
                if (!attributes.containsKey("stylesdir")) {
                    attrs.attribute("stylesdir", (Object)new File(this.extractedResources, "resources/html").getAbsolutePath());
                }
                if (attributes.containsKey("data-uri")) break;
                attrs.attribute("data-uri");
                break;
            }
            case "pdf": {
                if (!attributes.containsKey("pdf-style")) {
                    attrs.attribute("pdf-style", (Object)"talend.yml");
                }
                if (attributes.containsKey("pdf-stylesdir")) break;
                attrs.attribute("pdf-stylesdir", (Object)new File(this.extractedResources, "resources/pdf").getAbsolutePath());
                break;
            }
        }
        if (!attributes.containsKey("icons")) {
            attrs.attribute("icons", (Object)"font");
        }
        if (!attributes.containsKey("source-highlighter")) {
            attrs.attribute("source-highlighter", (Object)"coderay");
        }
        if (!attributes.containsKey("toc")) {
            attrs.attribute("toc", (Object)"left");
        }
    }

    private void extractResources(File workDir, Log log) {
        boolean workdirCreated = !workDir.exists();
        workDir.mkdirs();
        this.extractedResources = new File(workDir, this.getClass().getSimpleName() + "_resources");
        this.onClose = () -> {
            try {
                org.apache.ziplock.Files.remove((File)(workdirCreated ? workDir : this.extractedResources));
            }
            catch (IllegalStateException e) {
                log.error(e.getMessage());
            }
        };
        File file = JarLocation.jarLocation(AsciidoctorExecutor.class);
        if (file.isDirectory()) {
            Stream.of("html", "pdf").forEach(backend -> {
                File[] children = new File(file, "resources/" + backend).listFiles();
                if (children == null) {
                    throw new IllegalStateException("No resources folder for: " + backend);
                }
                Stream.of(children).forEach(child -> {
                    try {
                        this.copyResource(new File(this.extractedResources, "resources/" + backend + "/" + child.getName()), new FileInputStream((File)child));
                    }
                    catch (FileNotFoundException e) {
                        throw new IllegalStateException(e);
                    }
                });
            });
        } else {
            try (JarFile jar = new JarFile(file);){
                Collections.list(jar.entries()).stream().filter(e -> e.getName().startsWith("resources/") && !e.isDirectory()).forEach(e -> {
                    try {
                        this.copyResource(new File(this.extractedResources, e.getName()), jar.getInputStream((ZipEntry)e));
                    }
                    catch (IOException e1) {
                        throw new IllegalStateException(e1);
                    }
                });
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }
    }

    private void copyResource(File out, InputStream inputStream) {
        out.getParentFile().mkdirs();
        try (BufferedInputStream is = new BufferedInputStream(inputStream);
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));){
            IO.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e1) {
            throw new IllegalStateException(e1);
        }
    }

    private String wrap(String title, String version, File source) {
        try {
            String content = String.join((CharSequence)"\n", Files.readAllLines(source.toPath(), StandardCharsets.UTF_8));
            if (content.startsWith("= ")) {
                return content;
            }
            return "= " + title + "\n:revnumber: " + version + "\n\n" + content;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Asciidoctor getAsciidoctor() {
        return this.asciidoctor == null ? (this.asciidoctor = Asciidoctor.Factory.create()) : this.asciidoctor;
    }

    @Override
    public void close() {
        this.onClose.run();
        if (this.asciidoctor != null && !Boolean.getBoolean("talend.component.tools.jruby.teardown.skip")) {
            if (AutoCloseable.class.isInstance(this.asciidoctor)) {
                try {
                    ((AutoCloseable)AutoCloseable.class.cast(this.asciidoctor)).close();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            } else if (JRubyAsciidoctor.class.isInstance(this.asciidoctor)) {
                ((JRubyAsciidoctor)JRubyAsciidoctor.class.cast(this.asciidoctor)).getRubyRuntime().tearDown();
            }
        }
    }
}

