/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.configuration.type.DataSet;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.api.processor.AfterGroup;
import org.talend.sdk.component.api.processor.ElementListener;
import org.talend.sdk.component.api.processor.Output;
import org.talend.sdk.component.api.processor.Processor;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.ParameterModelService;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.BaseParameterEnricher;
import org.talend.sdk.component.runtime.manager.service.LocalConfigurationService;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class DatasetValidator
implements Validator {
    private final Validators.ValidatorHelper helper;

    public DatasetValidator(Validators.ValidatorHelper helper) {
        this.helper = helper;
    }

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        List datasetClasses = finder.findAnnotatedClasses(DataSet.class);
        Map datasets = datasetClasses.stream().collect(Collectors.toMap(Function.identity(), d -> d.getAnnotation(DataSet.class).value()));
        Stream<String> duplicated = DatasetValidator.duplicatedDataset(datasets.values());
        Stream<String> i18nError = datasets.entrySet().stream().map(entry -> this.helper.validateFamilyI18nKey((Class)entry.getKey(), "${family}.dataset." + (String)entry.getValue() + "._displayName")).filter(Objects::nonNull);
        Map componentNeedingADataSet = components.stream().filter(c -> this.isSource((Class<?>)c) || this.isOutput((Class<?>)c)).collect(Collectors.toMap(Function.identity(), this.helper::buildOrGetParameters));
        Map<Class, Collection> inputs = componentNeedingADataSet.entrySet().stream().filter(it -> this.isSource((Class)it.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Stream<String> sourceWithoutDataset = datasets.entrySet().stream().filter(dataset -> inputs.isEmpty() || inputs.entrySet().stream().allMatch(input -> {
            Collection allProps = DatasetValidator.flatten((Collection)input.getValue()).collect(Collectors.toList());
            Collection datasetProperties = this.findNestedDataSets(allProps, (String)dataset.getValue()).collect(Collectors.toList());
            return !datasetProperties.isEmpty() && allProps.stream().filter(it -> datasetProperties.stream().noneMatch(dit -> it.getPath().equals(dit.getPath()) || it.getPath().startsWith(dit.getPath() + "."))).anyMatch(this::isRequired);
        })).map(dataset -> "No source instantiable without adding parameters for @DataSet(\"" + (String)dataset.getValue() + "\") (" + ((Class)dataset.getKey()).getName() + "), please ensure at least a source using this dataset can be used just filling the dataset information.").sorted();
        Stream<String> configWithoutDataset = componentNeedingADataSet.entrySet().stream().filter(it -> DatasetValidator.flatten((Collection)it.getValue()).noneMatch(prop -> "dataset".equals(prop.getMetadata().get("tcomp::configurationtype::type")) || "datasetDiscovery".equals(prop.getMetadata().get("tcomp::configurationtype::type")))).map(it -> "The component " + ((Class)it.getKey()).getName() + " is missing a dataset in its configuration (see @DataSet)").sorted();
        BaseParameterEnricher.Context context = new BaseParameterEnricher.Context((LocalConfiguration)new LocalConfigurationService(Collections.emptyList(), "tools"));
        Stream<String> withoutStore = datasetClasses.stream().map(ds -> this.findDatasetWithoutDataStore((Class<?>)ds, context)).filter(Objects::nonNull).sorted();
        return Stream.of(duplicated, i18nError, sourceWithoutDataset, configWithoutDataset, withoutStore).reduce(Stream::concat).orElseGet(Stream::empty);
    }

    private String findDatasetWithoutDataStore(Class<?> ds, BaseParameterEnricher.Context context) {
        List dataset = this.helper.getParameterModelService().buildParameterMetas(Stream.of(new ParameterModelService.Param(ds, ds.getAnnotations(), "dataset")), ds, Optional.ofNullable(ds.getPackage()).map(Package::getName).orElse(""), true, context);
        if (DatasetValidator.flatten(dataset).noneMatch(prop -> "datastore".equals(prop.getMetadata().get("tcomp::configurationtype::type")))) {
            return "The dataset " + ds.getName() + " is missing a datastore reference in its configuration (see @DataStore)";
        }
        return null;
    }

    protected static Stream<String> duplicatedDataset(Collection<String> datasets) {
        HashSet<String> uniqueDatasets = new HashSet<String>(datasets);
        if (datasets.size() != uniqueDatasets.size()) {
            return Stream.of("Duplicated DataSet found : " + datasets.stream().collect(Collectors.groupingBy(Function.identity())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.joining(", ")));
        }
        return Stream.empty();
    }

    protected static Stream<ParameterMeta> flatten(Collection<ParameterMeta> options) {
        return options.stream().flatMap(it -> Stream.concat(Stream.of(it), it.getNestedParameters().isEmpty() ? Stream.empty() : DatasetValidator.flatten(it.getNestedParameters())));
    }

    private boolean isSource(Class<?> component) {
        return component.isAnnotationPresent(PartitionMapper.class) || component.isAnnotationPresent(Emitter.class);
    }

    private boolean isOutput(Class<?> component) {
        return component.isAnnotationPresent(Processor.class) && Stream.of(component.getMethods()).filter(it -> it.isAnnotationPresent(ElementListener.class) || it.isAnnotationPresent(AfterGroup.class)).allMatch(it -> Void.TYPE == it.getReturnType() && Stream.of(it.getParameters()).noneMatch(param -> param.isAnnotationPresent(Output.class)));
    }

    private Stream<ParameterMeta> findNestedDataSets(Collection<ParameterMeta> options, String name) {
        return options.stream().filter(it -> "dataset".equals(it.getMetadata().get("tcomp::configurationtype::type")) && name.equals(it.getMetadata().get("tcomp::configurationtype::name")));
    }

    private boolean isRequired(ParameterMeta parameterMeta) {
        return Boolean.parseBoolean(parameterMeta.getMetadata().getOrDefault("tcomp::validation::required", "false"));
    }
}

