/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.tools.validator.Validator;

public class RecordValidator
implements Validator {
    private static final Set<String> WHITE_LIST_TCK_RECORD_BUILDER_PROVIDER = new HashSet<String>(Arrays.asList("org.talend.sdk.component.runtime.record.RecordImpl.withNewSchema(org.talend.sdk.component.api.record.Schema)", "org.talend.sdk.component.runtime.record.RecordImpl.BuilderImpl.before(java.lang.String)", "org.talend.sdk.component.runtime.record.RecordImpl.BuilderImpl.after(java.lang.String)", "org.talend.sdk.component.runtime.record.RecordImpl.BuilderImpl.withRecord(java.lang.String, org.talend.sdk.component.api.record.Record)", "org.talend.sdk.component.runtime.record.RecordImpl.BuilderImpl.removeEntry(org.talend.sdk.component.api.record.Schema$Entry)", "org.talend.sdk.component.runtime.record.RecordImpl.BuilderImpl.updateEntryByName(java.lang.String, org.talend.sdk.component.api.record.Schema$Entry)", "org.talend.sdk.component.api.record.Record.withNewSchema(org.talend.sdk.component.api.record.Schema)", "org.talend.sdk.component.api.record.Record$Builder.before(java.lang.String)", "org.talend.sdk.component.api.record.Record$Builder.after(java.lang.String)", "org.talend.sdk.component.api.record.Record$Builder.removeEntry(org.talend.sdk.component.api.record.Schema$Entry)", "org.talend.sdk.component.api.record.Record$Builder.withInstant(org.talend.sdk.component.api.record.Schema$Entry, java.time.Instant)", "org.talend.sdk.component.api.record.Record$Builder.updateEntryByName(java.lang.String, org.talend.sdk.component.api.record.Schema$Entry)", "org.talend.sdk.component.api.record.Record$Builder.updateEntryByName(java.lang.String, org.talend.sdk.component.api.record.Schema$Entry, java.util.function.Function)", "org.talend.sdk.component.api.record.Record$Builder.with(org.talend.sdk.component.api.record.Schema$Entry, java.lang.Object)", "org.talend.sdk.component.api.record.Record$Builder.withString(java.lang.String, java.lang.String)", "org.talend.sdk.component.api.record.Record$Builder.withString(org.talend.sdk.component.api.record.Schema$Entry, java.lang.String)", "org.talend.sdk.component.api.record.Record$Builder.withBytes(java.lang.String, [B)", "org.talend.sdk.component.api.record.Record$Builder.withBytes(org.talend.sdk.component.api.record.Schema$Entry, [B)", "org.talend.sdk.component.api.record.Record$Builder.withDateTime(java.lang.String, java.util.Date)", "org.talend.sdk.component.api.record.Record$Builder.withDateTime(org.talend.sdk.component.api.record.Schema$Entry, java.util.Date)", "org.talend.sdk.component.api.record.Record$Builder.withDateTime(java.lang.String, java.time.ZonedDateTime)", "org.talend.sdk.component.api.record.Record$Builder.withDateTime(org.talend.sdk.component.api.record.Schema$Entry, java.time.ZonedDateTime)", "org.talend.sdk.component.api.record.Record$Builder.withDecimal(java.lang.String, java.math.BigDecimal)", "org.talend.sdk.component.api.record.Record$Builder.withDecimal(org.talend.sdk.component.api.record.Schema$Entry, java.math.BigDecimal)", "org.talend.sdk.component.api.record.Record$Builder.withTimestamp(java.lang.String, long)", "org.talend.sdk.component.api.record.Record$Builder.withTimestamp(org.talend.sdk.component.api.record.Schema$Entry, long)", "org.talend.sdk.component.api.record.Record$Builder.withInstant(java.lang.String, java.time.Instant)", "org.talend.sdk.component.api.record.Record$Builder.withInstant(org.talend.sdk.component.api.record.Schema$Entry,java.time.Instant)", "org.talend.sdk.component.api.record.Record$Builder.withInt(java.lang.String, int)", "org.talend.sdk.component.api.record.Record$Builder.withInt(org.talend.sdk.component.api.record.Schema$Entry, int)", "org.talend.sdk.component.api.record.Record$Builder.withLong(java.lang.String, long)", "org.talend.sdk.component.api.record.Record$Builder.withLong(org.talend.sdk.component.api.record.Schema$Entry, long)", "org.talend.sdk.component.api.record.Record$Builder.withFloat(java.lang.String, float)", "org.talend.sdk.component.api.record.Record$Builder.withFloat(org.talend.sdk.component.api.record.Schema$Entry, float)", "org.talend.sdk.component.api.record.Record$Builder.withDouble(java.lang.String, double)", "org.talend.sdk.component.api.record.Record$Builder.withDouble(org.talend.sdk.component.api.record.Schema$Entry, double)", "org.talend.sdk.component.api.record.Record$Builder.withBoolean(java.lang.String, boolean)", "org.talend.sdk.component.api.record.Record$Builder.withBoolean(org.talend.sdk.component.api.record.Schema$Entry, boolean)", "org.talend.sdk.component.api.record.Record$Builder.withRecord(java.lang.String, org.talend.sdk.component.api.record.Record)", "org.talend.sdk.component.api.record.Record$Builder.withRecord(org.talend.sdk.component.api.record.Schema$Entry, org.talend.sdk.component.api.record.Record)", "org.talend.sdk.component.api.record.Record$Builder.withArray(org.talend.sdk.component.api.record.Schema$Entry, java.util.Collection)", "org.talend.sdk.component.api.record.RecordImpl.withNewSchema(org.talend.sdk.component.api.record.Schema)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.with(org.talend.sdk.component.api.record.Schema$Entry, java.lang.Object)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withString(java.lang.String, java.lang.String)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withString(org.talend.sdk.component.api.record.Schema$Entry, java.lang.String)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withBytes(java.lang.String, [B)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withBytes(org.talend.sdk.component.api.record.Schema$Entry, [B)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withDateTime(java.lang.String, java.util.Date)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withDateTime(org.talend.sdk.component.api.record.Schema$Entry, java.util.Date)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withDateTime(java.lang.String, java.time.ZonedDateTime)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withDateTime(org.talend.sdk.component.api.record.Schema$Entry, java.time.ZonedDateTime)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withDecimal(java.lang.String, java.math.BigDecimal)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withDecimal(org.talend.sdk.component.api.record.Schema$Entry, java.math.BigDecimal)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withTimestamp(java.lang.String, long)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withTimestamp(org.talend.sdk.component.api.record.Schema$Entry, long)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withInstant(java.lang.String, java.time.Instant)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withInstant(org.talend.sdk.component.api.record.Schema$Entry,java.time.Instant)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withInt(java.lang.String, int)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withInt(org.talend.sdk.component.api.record.Schema$Entry, int)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withLong(java.lang.String, long)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withLong(org.talend.sdk.component.api.record.Schema$Entry, long)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withFloat(java.lang.String, float)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withFloat(org.talend.sdk.component.api.record.Schema$Entry, float)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withDouble(java.lang.String, double)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withDouble(org.talend.sdk.component.api.record.Schema$Entry, double)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withBoolean(java.lang.String, boolean)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withBoolean(org.talend.sdk.component.api.record.Schema$Entry, boolean)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withRecord(java.lang.String, org.talend.sdk.component.api.record.Record)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withRecord(org.talend.sdk.component.api.record.Schema$Entry, org.talend.sdk.component.api.record.Record)", "org.talend.sdk.component.api.record.RecordImpl.BuilderImpl.withArray(org.talend.sdk.component.api.record.Schema$Entry, java.util.Collection)"));

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        ArrayList messages = new ArrayList();
        components.stream().forEach(component -> messages.addAll(this.validateMethods(component.getDeclaredMethods())));
        return messages.stream();
    }

    private List<String> validateMethods(Method[] methods) {
        ArrayList<String> messages = new ArrayList<String>();
        Arrays.stream(methods).forEach(method -> {
            if (RecordValidator.isProducing(method, Record.Builder.class) && !RecordValidator.isSafeEntryBuilderProvider(method)) {
                String errorMessage = String.join((CharSequence)"\n", Arrays.asList(String.format("Method %s calls unsafe Builder creator. This either means:", RecordValidator.getFullName(method)), "  * That the TCK method is safe and should belong to WHITE_LIST_TCK_RECORD_BUILDER_PROVIDER"));
                messages.add(errorMessage);
            }
        });
        return messages;
    }

    private static boolean isSafeEntryBuilderProvider(Method method) {
        return WHITE_LIST_TCK_RECORD_BUILDER_PROVIDER.contains(RecordValidator.getFullName(method));
    }

    protected static boolean isProducing(Method method, Class<?> clazz) {
        return RecordValidator.areTheSameClass(method.getReturnType(), clazz);
    }

    private static boolean areTheSameClass(Class javaClass, Class<?> clazz) {
        return javaClass.getPackage() != null && javaClass.getPackage().getName().equals(clazz.getPackage().getName()) && javaClass.isAssignableFrom(clazz);
    }

    protected static String getFullName(Method method) {
        return RecordValidator.formatMethod(method.getDeclaringClass().getName(), method.getName(), RecordValidator.namesOf(method.getParameters()));
    }

    private static String formatMethod(String ownerName, String methodName, String parameters) {
        return ownerName + "." + methodName + "(" + parameters + ")";
    }

    private static String namesOf(Parameter[] parameters) {
        return Arrays.stream(parameters).map(type -> type.getType().getName()).collect(Collectors.joining(", "));
    }
}

