/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.configuration.type.DatasetDiscovery;
import org.talend.sdk.component.api.configuration.type.DatasetDiscoveryConfiguration;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.runtime.manager.reflect.ParameterModelService;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.BaseParameterEnricher;
import org.talend.sdk.component.runtime.manager.service.LocalConfigurationService;
import org.talend.sdk.component.tools.validator.DatasetValidator;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class DatasetDiscoveryValidator
implements Validator {
    private final Validators.ValidatorHelper helper;

    public DatasetDiscoveryValidator(Validators.ValidatorHelper helper) {
        this.helper = helper;
    }

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        List datasetDiscoveryClasses = finder.findAnnotatedClasses(DatasetDiscovery.class);
        Map datasetDiscoveries = datasetDiscoveryClasses.stream().collect(Collectors.toMap(Function.identity(), d -> d.getAnnotation(DatasetDiscovery.class).value()));
        Stream<String> duplicated = DatasetValidator.duplicatedDataset(datasetDiscoveries.values());
        Stream<String> i18nError = datasetDiscoveries.entrySet().stream().map(entry -> this.helper.validateFamilyI18nKey((Class)entry.getKey(), "${family}.datasetdiscovery." + (String)entry.getValue() + "._displayName")).filter(Objects::nonNull);
        BaseParameterEnricher.Context context = new BaseParameterEnricher.Context((LocalConfiguration)new LocalConfigurationService(Collections.emptyList(), "tools"));
        Stream<String> withoutStore = datasetDiscoveryClasses.stream().map(ds -> this.findDatasetDiscoveryWithoutDataStore((Class<?>)ds, context)).filter(Objects::nonNull).sorted();
        Stream<String> implementationError = datasetDiscoveryClasses.stream().filter(ds -> !DatasetDiscoveryConfiguration.class.isAssignableFrom((Class<?>)ds)).map(ds -> "Class " + ds.getName() + " must implement " + DatasetDiscoveryConfiguration.class).sorted();
        return Stream.of(duplicated, i18nError, withoutStore, implementationError).reduce(Stream::concat).orElseGet(Stream::empty);
    }

    private String findDatasetDiscoveryWithoutDataStore(Class<?> ds, BaseParameterEnricher.Context context) {
        List dataset = this.helper.getParameterModelService().buildParameterMetas(Stream.of(new ParameterModelService.Param(ds, ds.getAnnotations(), "datasetDiscovery")), ds, Optional.ofNullable(ds.getPackage()).map(Package::getName).orElse(""), true, context);
        if (DatasetValidator.flatten(dataset).noneMatch(prop -> "datastore".equals(prop.getMetadata().get("tcomp::configurationtype::type")))) {
            return "The datasetDiscovery " + ds.getName() + " is missing a datastore reference in its configuration (see @DataStore)";
        }
        return null;
    }
}

