/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cxf.common.util.StringUtils;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.configuration.action.Proposable;
import org.talend.sdk.component.api.configuration.action.Updatable;
import org.talend.sdk.component.api.configuration.type.DataSet;
import org.talend.sdk.component.api.configuration.type.DataStore;
import org.talend.sdk.component.api.meta.ConditionalOutput;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.ActionType;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.api.service.completion.DynamicValues;
import org.talend.sdk.component.api.service.dependency.DynamicDependencies;
import org.talend.sdk.component.api.service.discovery.DiscoverDataset;
import org.talend.sdk.component.api.service.healthcheck.HealthCheck;
import org.talend.sdk.component.api.service.outputs.AvailableOutputFlows;
import org.talend.sdk.component.api.service.schema.DiscoverSchema;
import org.talend.sdk.component.api.service.schema.DiscoverSchemaExtended;
import org.talend.sdk.component.api.service.update.Update;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class ActionValidator
implements Validator {
    private final Validators.ValidatorHelper helper;

    public ActionValidator(Validators.ValidatorHelper helper) {
        this.helper = helper;
    }

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        Stream<String> actionType = this.checkActionType(finder);
        Stream<String> actionWithoutParameter = finder.findAnnotatedMethods(DynamicValues.class).stream().filter(m -> this.countParameters((Method)m) != 0).map(m -> m + " should have no parameter").sorted();
        Stream<String> health = finder.findAnnotatedMethods(HealthCheck.class).stream().filter(m -> this.countParameters((Method)m) != 1 || !m.getParameterTypes()[0].isAnnotationPresent(DataStore.class)).map(m -> m + " should have its first parameter being a datastore (marked with @DataStore)").sorted();
        Stream<String> datasetDiscover = finder.findAnnotatedMethods(DiscoverDataset.class).stream().filter(m -> this.countParameters((Method)m) != 1 || !m.getParameterTypes()[0].isAnnotationPresent(DataStore.class)).map(m -> m + " should have a datastore as first parameter (marked with @DataStore)").sorted();
        Stream<String> discover = finder.findAnnotatedMethods(DiscoverSchema.class).stream().filter(m -> this.countParameters((Method)m) != 1 || !m.getParameterTypes()[0].isAnnotationPresent(DataSet.class)).map(m -> m + " should have its first parameter being a dataset (marked with @DataSet)").sorted();
        Stream<String> discoverProcessor = this.findDiscoverSchemaExtendedErrors(finder);
        Stream<String> dynamicDependencyErrors = this.findDynamicDependenciesErrors(finder);
        Stream<String> updatesErrors = this.findUpdatesErrors(finder);
        Stream<String> availableOutputFlowsErrors = this.findAvailableOutputFlowsErrors(finder);
        Stream<String> enumProposable = finder.findAnnotatedFields(Proposable.class).stream().filter(f -> f.getType().isEnum()).map(f -> f.toString() + " must not define @Proposable since it is an enum").sorted();
        Set proposables = finder.findAnnotatedFields(Proposable.class).stream().map(f -> f.getAnnotation(Proposable.class).value()).collect(Collectors.toSet());
        Set dynamicValues = finder.findAnnotatedMethods(DynamicValues.class).stream().map(f -> f.getAnnotation(DynamicValues.class).value()).collect(Collectors.toSet());
        proposables.removeAll(dynamicValues);
        Stream<String> proposableWithoutDynamic = proposables.stream().map(p -> "No @DynamicValues(\"" + p + "\"), add a service with this method: @DynamicValues(\"" + p + "\") Values proposals();").sorted();
        return Stream.of(actionType, actionWithoutParameter, health, datasetDiscover, discover, discoverProcessor, dynamicDependencyErrors, updatesErrors, availableOutputFlowsErrors, enumProposable, proposableWithoutDynamic).reduce(Stream::concat).orElseGet(Stream::empty);
    }

    private Stream<String> checkActionType(AnnotationFinder finder) {
        return Validators.getActionsStream().flatMap(action -> {
            Class returnedType = action.getAnnotation(ActionType.class).expectedReturnedType();
            List annotatedMethods = finder.findAnnotatedMethods(action);
            return Stream.concat(annotatedMethods.stream().filter(m -> !returnedType.isAssignableFrom(m.getReturnType())).map(m -> m + " doesn't return a " + returnedType + ", please fix it"), annotatedMethods.stream().filter(m -> !m.getDeclaringClass().isAnnotationPresent(Service.class) && !Modifier.isAbstract(m.getDeclaringClass().getModifiers())).map(m -> m + " is not declared into a service class"));
        }).sorted();
    }

    private Stream<String> findDiscoverSchemaExtendedErrors(AnnotationFinder finder) {
        Stream<String> optionParameter = finder.findAnnotatedMethods(DiscoverSchemaExtended.class).stream().filter(m -> !this.hasOption((Method)m)).map(m -> m + " should have a parameter being an option (marked with @Option)").sorted();
        Stream<String> returnType = finder.findAnnotatedMethods(DiscoverSchemaExtended.class).stream().filter(m -> !this.hasCorrectReturnType((Method)m)).map(m -> m + " should return a Schema assignable").sorted();
        Stream<String> incomingSchema = finder.findAnnotatedMethods(DiscoverSchemaExtended.class).stream().filter(m -> this.hasTypeParameter((Method)m, Schema.class)).filter(m -> !this.hasSchemaCorrectNaming((Method)m)).map(m -> m + " should have its Schema `incomingSchema' parameter named `incomingSchema'").sorted();
        Stream<String> branch = finder.findAnnotatedMethods(DiscoverSchemaExtended.class).stream().filter(m -> this.hasTypeParameter((Method)m, String.class)).filter(m -> !this.hasBranchCorrectNaming((Method)m)).map(m -> m + " should have its String `branch' parameter named `branch'").sorted();
        return Stream.of(returnType, optionParameter, incomingSchema, branch).reduce(Stream::concat).orElseGet(Stream::empty);
    }

    private Stream<String> findDynamicDependenciesErrors(AnnotationFinder finder) {
        Stream<String> optionParameter = finder.findAnnotatedMethods(DynamicDependencies.class).stream().filter(m -> !this.hasOption((Method)m) || !this.hasObjectParameter((Method)m)).map(m -> m + " should have an Object parameter marked with @Option").sorted();
        Stream<String> returnType = finder.findAnnotatedMethods(DynamicDependencies.class).stream().filter(m -> !this.hasStringInList((Method)m)).map(m -> m + " should return List<String>").sorted();
        return Stream.of(returnType, optionParameter).reduce(Stream::concat).orElseGet(Stream::empty);
    }

    private Stream<String> findAvailableOutputFlowsErrors(AnnotationFinder finder) {
        Stream<String> mustHasName = finder.findAnnotatedMethods(AvailableOutputFlows.class).stream().filter(m -> StringUtils.isEmpty((String)m.getName())).map(m -> m + " must have a name to pair with related Processor").sorted();
        Stream<String> mustHasNamePro = finder.findAnnotatedClasses(ConditionalOutput.class).stream().filter(p -> StringUtils.isEmpty((String)p.getAnnotation(ConditionalOutput.class).value())).map(p -> p + " must have a name to pair with related annotation @AvailableOutputFlows").sorted();
        Stream<String> returnType = finder.findAnnotatedMethods(AvailableOutputFlows.class).stream().filter(m -> !this.hasStringInList((Method)m)).map(m -> m + " should return List<String>").sorted();
        Stream<String> onlyOneProcessor = finder.findAnnotatedMethods(AvailableOutputFlows.class).stream().filter(m -> !this.hasOneSameNameProcessor(m.getAnnotation(AvailableOutputFlows.class).value(), finder)).map(m -> m + " should own one related processor for this method (by using @ConditionalOutputFlows)").sorted();
        Stream<String> sameConfigWithProcessor = finder.findAnnotatedMethods(AvailableOutputFlows.class).stream().filter(m -> !this.hasSameConfigInProcessor((Method)m, finder)).map(m -> m + " should use the same type of Configuration as the related processor for this method").sorted();
        return Stream.of(mustHasName, mustHasNamePro, returnType, onlyOneProcessor, sameConfigWithProcessor).reduce(Stream::concat).orElseGet(Stream::empty);
    }

    private boolean hasSameConfigInProcessor(Method method, AnnotationFinder finder) {
        return finder.findAnnotatedClasses(ConditionalOutput.class).stream().filter(p -> method.getAnnotation(AvailableOutputFlows.class).value().equals(p.getAnnotation(ConditionalOutput.class).value())).filter(p -> this.hasSameConfig(method, (Class<?>)p)).count() == 1L;
    }

    private boolean hasSameConfig(Method method, Class<?> p) {
        return Arrays.stream(method.getParameters()).filter(m -> Arrays.stream(p.getDeclaredFields()).filter(f -> f.getType() == m.getType()).count() == 1L).count() == 1L;
    }

    private boolean hasOneSameNameProcessor(String name, AnnotationFinder finder) {
        return finder.findAnnotatedClasses(ConditionalOutput.class).stream().filter(p -> name.equals(p.getAnnotation(ConditionalOutput.class).value())).count() == 1L;
    }

    private Stream<String> findUpdatesErrors(AnnotationFinder finder) {
        Map updates = finder.findAnnotatedMethods(Update.class).stream().collect(Collectors.toMap(m -> m.getAnnotation(Update.class).value(), Function.identity()));
        Stream<String> updateAction = updates.values().stream().filter(m -> this.isPrimitiveLike(m.getReturnType())).map(m -> m + " should return an object").sorted();
        List updatableFields = finder.findAnnotatedFields(Updatable.class);
        Stream<String> directChild = updatableFields.stream().filter(f -> f.getAnnotation(Updatable.class).after().contains(".")).map(f -> "@Updatable.after should only reference direct child primitive fields").sorted();
        Stream<String> noPrimitive = updatableFields.stream().filter(f -> this.isPrimitiveLike(f.getType())).map(f -> "@Updatable should not be used on primitives: " + f).sorted();
        Stream<String> serviceType = updatableFields.stream().map(f -> {
            Method service = (Method)updates.get(f.getAnnotation(Updatable.class).value());
            if (service == null) {
                return null;
            }
            if (f.getType().isAssignableFrom(service.getReturnType())) {
                return null;
            }
            return "@Updatable field '" + f + "' does not match returned type of '" + service + "'";
        }).filter(Objects::nonNull).sorted();
        Stream<String> noFieldUpdatable = updatableFields.stream().filter(f -> updates.get(f.getAnnotation(Updatable.class).value()) == null).map(f -> "No @Update service found for field " + f + ", did you intend to use @Updatable?").sorted();
        return Stream.of(updateAction, directChild, noPrimitive, serviceType, noFieldUpdatable).reduce(Stream::concat).orElseGet(Stream::empty);
    }

    private int countParameters(Method m) {
        return this.countParameters(m.getParameters());
    }

    private int countParameters(Parameter[] params) {
        return (int)Stream.of(params).filter(p -> !this.helper.isService((Parameter)p)).count();
    }

    private boolean isPrimitiveLike(Class<?> type) {
        return type.isPrimitive() || type == String.class;
    }

    private boolean hasOption(Method method) {
        return Arrays.stream(method.getParameters()).filter(p -> p.isAnnotationPresent(Option.class)).count() == 1L;
    }

    private boolean hasTypeParameter(Method method, Class<?> clazz) {
        return Arrays.stream(method.getParameters()).filter(p -> clazz.isAssignableFrom(p.getType())).count() == 1L;
    }

    private boolean hasSchemaCorrectNaming(Method method) {
        return Arrays.stream(method.getParameters()).filter(p -> Schema.class.isAssignableFrom(p.getType())).filter(p -> "incomingSchema".equals(p.getName())).count() == 1L;
    }

    private boolean hasObjectParameter(Method method) {
        return Arrays.stream(method.getParameters()).filter(p -> !this.isPrimitiveLike(p.getType())).count() == 1L;
    }

    private boolean hasBranchCorrectNaming(Method method) {
        return Arrays.stream(method.getParameters()).filter(p -> String.class.isAssignableFrom(p.getType())).filter(p -> "branch".equals(p.getName())).count() == 1L;
    }

    private boolean hasCorrectReturnType(Method method) {
        return Schema.class.isAssignableFrom(method.getReturnType());
    }

    private boolean hasStringInList(Method method) {
        Type[] actualTypeArguments;
        if (List.class.isAssignableFrom(method.getReturnType()) && method.getGenericReturnType() instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()).length > 0) {
            return "java.lang.String".equals(actualTypeArguments[0].getTypeName());
        }
        return false;
    }
}

