/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.service.http.HttpClient;
import org.talend.sdk.component.api.service.http.Request;
import org.talend.sdk.component.runtime.manager.service.http.HttpClientFactoryImpl;
import org.talend.sdk.component.tools.validator.Validator;

public class HttpValidator
implements Validator {
    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        List classErrors = components.stream().filter(c -> HttpClient.class.isAssignableFrom((Class<?>)c) && finder.findAnnotatedMethods(Request.class).isEmpty()).map(c -> c.getCanonicalName() + " extends HttpClient should use @Request on methods").collect(Collectors.toList());
        List methodError = finder.findAnnotatedMethods(Request.class).stream().map(Method::getDeclaringClass).distinct().flatMap(c -> HttpClientFactoryImpl.createErrors((Class)c).stream()).sorted().collect(Collectors.toList());
        return Stream.concat(classErrors.stream(), methodError.stream());
    }
}

