/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.service.schema.DiscoverSchema;
import org.talend.sdk.component.api.service.schema.DiscoverSchemaExtended;
import org.talend.sdk.component.api.service.schema.FixedSchema;
import org.talend.sdk.component.tools.validator.Validator;

public class FixedSchemaValidator
implements Validator {
    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        ArrayList errors = new ArrayList();
        Map classes = finder.findAnnotatedClasses(FixedSchema.class).stream().collect(Collectors.toMap(Function.identity(), d -> d.getAnnotation(FixedSchema.class).value()));
        errors.addAll(classes.entrySet().stream().filter(e -> ((String)e.getValue()).isEmpty()).map(e -> String.format("Empty @FixedSchema annotation's value in class %s.", ((Class)e.getKey()).getSimpleName())).collect(Collectors.toList()));
        List methods = Stream.concat(finder.findAnnotatedMethods(DiscoverSchema.class).stream().map(m -> m.getDeclaredAnnotation(DiscoverSchema.class).value()), finder.findAnnotatedMethods(DiscoverSchemaExtended.class).stream().map(m -> m.getDeclaredAnnotation(DiscoverSchemaExtended.class).value())).collect(Collectors.toList());
        errors.addAll(classes.entrySet().stream().filter(e -> !((String)e.getValue()).isEmpty()).filter(e -> !methods.contains(e.getValue())).map(e -> String.format("@FixedSchema '%s' in class %s is not declared anywhere as DiscoverSchema*.", e.getValue(), ((Class)e.getKey()).getSimpleName())).collect(Collectors.toList()));
        return errors.stream();
    }
}

