/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.configuration.action.Checkable;
import org.talend.sdk.component.api.configuration.type.DataStore;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.api.service.healthcheck.HealthCheck;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class DataStoreValidator
implements Validator {
    private final Validators.ValidatorHelper helper;

    public DataStoreValidator(Validators.ValidatorHelper helper) {
        this.helper = helper;
    }

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        ArrayList<String> errors = new ArrayList<String>();
        List datastoreClasses = finder.findAnnotatedClasses(DataStore.class);
        List datastores = datastoreClasses.stream().map(d -> d.getAnnotation(DataStore.class).value()).collect(Collectors.toList());
        HashSet uniqueDatastores = new HashSet(datastores);
        if (datastores.size() != uniqueDatastores.size()) {
            errors.add("Duplicated DataStore found : " + datastores.stream().collect(Collectors.groupingBy(Function.identity())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.joining(", ")));
        }
        List checkableClasses = finder.findAnnotatedClasses(Checkable.class);
        errors.addAll(checkableClasses.stream().filter(d -> !d.isAnnotationPresent(DataStore.class)).map(c -> c.getName() + " has @Checkable but is not a @DataStore").sorted().collect(Collectors.toList()));
        Map<String, String> checkableDataStoresMap = checkableClasses.stream().filter(d -> d.isAnnotationPresent(DataStore.class)).collect(Collectors.toMap(d -> d.getAnnotation(DataStore.class).value(), d -> d.getAnnotation(Checkable.class).value()));
        Set healthchecks = finder.findAnnotatedMethods(HealthCheck.class).stream().filter(h -> h.getDeclaringClass().isAnnotationPresent(Service.class)).map(m -> m.getAnnotation(HealthCheck.class).value()).collect(Collectors.toSet());
        errors.addAll(checkableDataStoresMap.entrySet().stream().filter(e -> !healthchecks.contains(e.getValue())).map(e -> "No @HealthCheck for dataStore: '" + (String)e.getKey() + "' with checkable: '" + (String)e.getValue() + "'").sorted().collect(Collectors.toList()));
        errors.addAll(datastoreClasses.stream().map(clazz -> this.helper.validateFamilyI18nKey((Class<?>)clazz, "${family}.datastore." + clazz.getAnnotation(DataStore.class).value() + "._displayName")).filter(Objects::nonNull).collect(Collectors.toList()));
        return errors.stream();
    }
}

