/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.internationalization.Internationalized;
import org.talend.sdk.component.api.service.ActionType;
import org.talend.sdk.component.api.service.asyncvalidation.AsyncValidation;
import org.talend.sdk.component.api.service.completion.DynamicValues;
import org.talend.sdk.component.api.service.completion.Suggestions;
import org.talend.sdk.component.api.service.healthcheck.HealthCheck;
import org.talend.sdk.component.api.service.schema.DiscoverSchema;
import org.talend.sdk.component.api.service.update.Update;
import org.talend.sdk.component.tools.ComponentHelper;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class InternationalizationValidator
implements Validator {
    private static final Logger log = LoggerFactory.getLogger(InternationalizationValidator.class);
    private final Validators.ValidatorHelper helper;
    private final File sourceRoot;
    private final boolean validatePlaceholder;
    private final boolean autofix;

    public InternationalizationValidator(Validators.ValidatorHelper helper, File sourceRoot, boolean validatePlaceholder, boolean autofix) {
        this.helper = helper;
        this.sourceRoot = sourceRoot;
        this.validatePlaceholder = validatePlaceholder;
        this.autofix = autofix;
    }

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        Stream<Object> missingPlaceholder;
        Stream<Object> missingDisplayName;
        Stream<String> bundlesError = components.stream().map(this::validateComponentResourceBundle).filter(Objects::nonNull).sorted();
        ArrayList<Fix> toFix = new ArrayList<Fix>();
        List optionsFields = finder.findAnnotatedFields(Option.class);
        Stream missingDisplayNameEnum = optionsFields.stream().map(Field::getType).filter(Class::isEnum).distinct().flatMap(enumType -> Stream.of(enumType.getFields()).filter(f -> Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers())).filter(f -> this.hasNoBundleEntry((Class<?>)enumType, (Field)f, "_displayName")).peek(f -> {
            if (this.autofix) {
                toFix.add(new Fix((Field)f, "._displayName", this.sourceRoot, true));
            }
        }).map(f -> "Missing key " + enumType.getSimpleName() + "." + f.getName() + "._displayName in " + enumType + " resource bundle")).sorted();
        List missingOptionTranslations = Stream.concat(optionsFields.stream().distinct().filter(this::fieldIsWithoutKey).peek(f -> {
            if (this.autofix) {
                toFix.add(new Fix((Field)f, "._displayName", this.sourceRoot, true));
            }
        }).map(f -> " " + f.getDeclaringClass().getSimpleName() + "." + f.getName() + "._displayName = <" + f.getName() + ">").sorted().distinct(), missingDisplayNameEnum).collect(Collectors.toList());
        List missingPlaceholderTranslations = Collections.emptyList();
        if (this.validatePlaceholder) {
            missingPlaceholderTranslations = optionsFields.stream().distinct().filter(e -> this.fieldIsWithoutKey((Field)e, Arrays.asList(String.class, Character.class, Integer.class, Double.class, Long.class, Float.class, Date.class, ZonedDateTime.class), "._placeholder")).peek(f -> {
                if (this.autofix) {
                    toFix.add(new Fix((Field)f, "._placeholder", this.sourceRoot, false));
                }
            }).map(f -> " " + f.getDeclaringClass().getSimpleName() + "." + f.getName() + "._placeholder = ").sorted().distinct().collect(Collectors.toList());
        }
        if (this.autofix && !toFix.isEmpty()) {
            this.fixLocales(toFix);
        }
        if (missingOptionTranslations != null && !missingOptionTranslations.isEmpty() && !this.autofix) {
            String missingMsg = missingOptionTranslations.stream().collect(Collectors.joining("\n", "Missing _displayName resource bundle entries:\n", ""));
            missingDisplayName = Stream.of(missingMsg);
        } else {
            missingDisplayName = Stream.empty();
        }
        if (missingPlaceholderTranslations != null && !missingPlaceholderTranslations.isEmpty() & !this.autofix) {
            String missingMsg = missingPlaceholderTranslations.stream().collect(Collectors.joining("\n", "Missing _placeholder resource bundle entries:\n", ""));
            missingPlaceholder = Stream.of(missingMsg);
        } else {
            missingPlaceholder = Stream.empty();
        }
        ArrayList<String> internationalizedErrors = new ArrayList<String>();
        for (Class i : finder.findAnnotatedClasses(Internationalized.class)) {
            ResourceBundle resourceBundle = this.helper.findResourceBundle(i);
            if (resourceBundle != null) {
                Collection keys = Stream.of(i.getMethods()).filter(m -> m.getDeclaringClass() != Object.class).map(m -> Arrays.asList(i.getName() + "." + m.getName(), i.getSimpleName() + "." + m.getName())).collect(Collectors.toSet());
                keys.stream().filter(ks -> ks.stream().noneMatch(resourceBundle::containsKey)).map(k -> "Missing key " + (String)k.iterator().next() + " in " + i + " resource bundle").sorted().forEach(internationalizedErrors::add);
                resourceBundle.keySet().stream().filter(k -> (k.startsWith(i.getName() + ".") || k.startsWith(i.getSimpleName() + ".")) && keys.stream().noneMatch(ks -> ks.contains(k))).map(k -> "Key " + k + " from " + i + " is no more used").sorted().forEach(internationalizedErrors::add);
                continue;
            }
            internationalizedErrors.add("No resource bundle for " + i);
        }
        Stream<String> actionsErrors = this.missingActionComment(finder);
        Stream result = Stream.of(bundlesError, missingDisplayName, missingPlaceholder, internationalizedErrors.stream(), actionsErrors).reduce(Stream::concat).orElseGet(Stream::empty);
        if (this.autofix) {
            List forLogs = result.collect(Collectors.toList());
            String resultAutoFix = forLogs.stream().collect(Collectors.joining("\n", "Automatically fixed missing labels:\n", "\n\nPlease, check changes and disable '-Dtalend.validation.internationalization.autofix=false' / '<validateInternationalizationAutoFix>false</>'property.\n\n"));
            log.info(resultAutoFix);
            result = forLogs.stream();
        }
        return result;
    }

    private Stream<String> missingActionComment(AnnotationFinder finder) {
        return this.getActionsStream().flatMap(action -> finder.findAnnotatedMethods(action).stream()).map(action -> {
            String key;
            Annotation actionAnnotation = Stream.of(action.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(ActionType.class)).findFirst().orElseThrow(() -> new IllegalArgumentException("No action annotation on " + action));
            try {
                Class<? extends Annotation> annotationType = actionAnnotation.annotationType();
                key = "${family}.actions." + annotationType.getAnnotation(ActionType.class).value() + "." + annotationType.getMethod("value", new Class[0]).invoke((Object)actionAnnotation, new Object[0]).toString() + "._displayName";
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
            return this.helper.validateFamilyI18nKey(action.getDeclaringClass(), key);
        }).filter(Objects::nonNull);
    }

    private Stream<Class<? extends Annotation>> getActionsStream() {
        return Stream.of(AsyncValidation.class, DynamicValues.class, HealthCheck.class, DiscoverSchema.class, Suggestions.class, Update.class);
    }

    private String validateComponentResourceBundle(Class<?> component) {
        String baseName = Optional.ofNullable(component.getPackage()).map(p -> p.getName() + ".").orElse("") + "Messages";
        ResourceBundle bundle = this.helper.findResourceBundle(component);
        if (bundle == null) {
            return "No resource bundle for " + component.getName() + ", you should create a " + baseName.replace('.', '/') + ".properties at least.";
        }
        String prefix = this.findPrefix(component);
        Collection missingKeys = Stream.of("_displayName").map(n -> prefix + "." + n).filter(k -> !bundle.containsKey((String)k)).collect(Collectors.toList());
        if (!missingKeys.isEmpty()) {
            return baseName + " is missing the key(s): " + String.join((CharSequence)"\n", missingKeys);
        }
        return null;
    }

    private String findPrefix(Class<?> component) {
        return ComponentHelper.components(component).map(c -> ComponentHelper.findFamily(c, component) + "." + c.name()).orElseThrow(() -> new IllegalStateException(component.getName()));
    }

    private boolean hasNoBundleEntry(Class<?> enumType, Field f, String keyName) {
        ResourceBundle bundle = this.findBundleFor(enumType, f);
        String key = enumType.getSimpleName() + "." + f.getName() + "." + keyName;
        return bundle == null || !bundle.containsKey(key);
    }

    private ResourceBundle findBundleFor(Class<?> enumType, Field f) {
        return Optional.ofNullable(this.helper.findResourceBundle(enumType)).orElseGet(() -> this.helper.findResourceBundle(f.getDeclaringClass()));
    }

    private boolean fieldIsWithoutKey(Field field) {
        return this.fieldIsWithoutKey(field, Collections.emptyList(), "._displayName");
    }

    private boolean fieldIsWithoutKey(Field field, List<Class> types, String suffix) {
        TypeDescriptor.OfField<Class<?>> tmpFieldType = field.getType();
        if (tmpFieldType.isPrimitive()) {
            tmpFieldType = MethodType.methodType(tmpFieldType).wrap().returnType();
        }
        Class<?> fieldType = tmpFieldType;
        if (!types.isEmpty() && !types.contains(tmpFieldType)) {
            return false;
        }
        ResourceBundle bundle = Optional.ofNullable(this.helper.findResourceBundle(field.getDeclaringClass())).orElseGet(() -> this.helper.findResourceBundle(fieldType));
        String key = field.getDeclaringClass().getSimpleName() + "." + field.getName() + suffix;
        return bundle == null || !bundle.containsKey(key);
    }

    private void fixLocales(List<Fix> toFix) {
        Map<Path, List<Fix>> fixByPath = toFix.stream().collect(Collectors.groupingBy(Fix::getDestinationFile));
        for (Path p : fixByPath.keySet()) {
            try {
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                if (!Files.exists(p, new LinkOption[0])) {
                    Files.createFile(p, new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Can't create resource file '%s' : %s", p, e.getMessage()), e);
            }
            List<Fix> fixes = fixByPath.get(p);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(p.toFile(), true));){
                for (Fix f : fixes) {
                    writer.newLine();
                    writer.write(f.key);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Can't fix internationalization file: '%s'", p), e);
            }
        }
    }

    private static class Fix {
        private final String key;
        private final Path destinationFile;

        public Fix(Field field, String suffix, File sourceRoot, boolean defaultValue) {
            this.key = this.computeKey(field, suffix, defaultValue);
            this.destinationFile = this.computeDestinationFile(field, sourceRoot);
        }

        private String computeKey(Field field, String suffix, boolean defaultValue) {
            String s = field.getDeclaringClass().getSimpleName() + "." + field.getName() + suffix + " = ";
            if (defaultValue) {
                s = s + "<" + field.getName() + ">";
            }
            return s;
        }

        private Path computeDestinationFile(Field field, File sourceRoot) {
            String packageName = field.getDeclaringClass().getPackage().getName();
            Path path = Paths.get(sourceRoot.getAbsolutePath(), new String[0]).resolve("src").resolve("main").resolve("resources").resolve(Paths.get(packageName.replaceAll("\\.", "/"), new String[0])).resolve("Messages.properties");
            return path;
        }

        public String getKey() {
            return this.key;
        }

        public Path getDestinationFile() {
            return this.destinationFile;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fix)) {
                return false;
            }
            Fix other = (Fix)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Path this$destinationFile = this.getDestinationFile();
            Path other$destinationFile = other.getDestinationFile();
            return !(this$destinationFile == null ? other$destinationFile != null : !((Object)this$destinationFile).equals(other$destinationFile));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Fix;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Path $destinationFile = this.getDestinationFile();
            result = result * 59 + ($destinationFile == null ? 43 : ((Object)$destinationFile).hashCode());
            return result;
        }

        public String toString() {
            return "InternationalizationValidator.Fix(key=" + this.getKey() + ", destinationFile=" + this.getDestinationFile() + ")";
        }
    }
}

